/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.common;

import com.tencent.common.Util;
import com.tencent.protocol.refund_query_protocol.RefundOrderData;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLParser {
    public static List<RefundOrderData> getRefundOrderList(String refundQueryResponseString) throws IOException, SAXException, ParserConfigurationException {
        ArrayList<RefundOrderData> list = new ArrayList<RefundOrderData>();
        Map<String, Object> map = XMLParser.getMapFromXML(refundQueryResponseString);
        int count = Integer.parseInt((String)map.get("refund_count"));
        Util.log("count:" + count);
        if (count < 1) {
            return list;
        }
        for (int i = 0; i < count; ++i) {
            RefundOrderData refundOrderData = new RefundOrderData();
            refundOrderData.setOutRefundNo(Util.getStringFromMap(map, "out_refund_no_" + i, ""));
            refundOrderData.setRefundID(Util.getStringFromMap(map, "refund_id_" + i, ""));
            refundOrderData.setRefundChannel(Util.getStringFromMap(map, "refund_channel_" + i, ""));
            refundOrderData.setRefundFee(Util.getIntFromMap(map, "refund_fee_" + i));
            refundOrderData.setCouponRefundFee(Util.getIntFromMap(map, "coupon_refund_fee_" + i));
            refundOrderData.setRefundStatus(Util.getStringFromMap(map, "refund_status_" + i, ""));
            list.add(refundOrderData);
        }
        return list;
    }

    public static Map<String, Object> getMapFromXML(String xmlString) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputStream is = Util.getStringStream(xmlString);
        Document document = builder.parse(is);
        NodeList allNodes = document.getFirstChild().getChildNodes();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < allNodes.getLength(); ++i) {
            Node node = allNodes.item(i);
            if (!(node instanceof Element)) continue;
            map.put(node.getNodeName(), node.getTextContent());
        }
        return map;
    }
}

