/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.business;

import com.tencent.common.Configure;
import com.tencent.common.Log;
import com.tencent.common.Util;
import com.tencent.common.report.ReporterFactory;
import com.tencent.common.report.protocol.ReportReqData;
import com.tencent.common.report.service.ReportService;
import com.tencent.protocol.downloadbill_protocol.DownloadBillReqData;
import com.tencent.protocol.downloadbill_protocol.DownloadBillResData;
import com.tencent.service.DownloadBillService;
import com.thoughtworks.xstream.io.StreamException;
import org.slf4j.LoggerFactory;

public class DownloadBillBusiness {
    private static Log log = new Log(LoggerFactory.getLogger(DownloadBillBusiness.class));
    private static String result = "";
    private DownloadBillService downloadBillService = new DownloadBillService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(DownloadBillReqData downloadBillReqData, ResultListener resultListener) throws Exception {
        long costTimeStart = System.currentTimeMillis();
        log.i("\u5bf9\u8d26\u5355API\u8fd4\u56de\u7684\u6570\u636e\u5982\u4e0b\uff1a");
        String downloadBillServiceResponseString = this.downloadBillService.request(downloadBillReqData);
        long costTimeEnd = System.currentTimeMillis();
        long totalTimeCost = costTimeEnd - costTimeStart;
        log.i("api\u8bf7\u6c42\u603b\u8017\u65f6\uff1a" + totalTimeCost + "ms");
        log.i(downloadBillServiceResponseString);
        String returnCode = "";
        String returnMsg = "";
        try {
            DownloadBillResData downloadBillResData = (DownloadBillResData)Util.getObjectFromXML(downloadBillServiceResponseString, DownloadBillResData.class);
            if (downloadBillResData == null || downloadBillResData.getReturn_code() == null) {
                this.setResult("Case1:\u5bf9\u8d26\u5355API\u8bf7\u6c42\u903b\u8f91\u9519\u8bef\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u6d4b\u4f20\u8fc7\u53bb\u7684\u6bcf\u4e00\u4e2a\u53c2\u6570\u662f\u5426\u5408\u6cd5\uff0c\u6216\u662f\u770bAPI\u80fd\u5426\u88ab\u6b63\u5e38\u8bbf\u95ee", "logTypeError");
                resultListener.onFailByReturnCodeError(downloadBillResData);
                return;
            }
            if (downloadBillResData.getReturn_code().equals("FAIL")) {
                this.setResult("Case2:\u5bf9\u8d26\u5355API\u7cfb\u7edf\u8fd4\u56de\u5931\u8d25\uff0c\u8bf7\u68c0\u6d4bPost\u7ed9API\u7684\u6570\u636e\u662f\u5426\u89c4\u8303\u5408\u6cd5", "logTypeError");
                resultListener.onFailByReturnCodeFail(downloadBillResData);
                returnCode = "FAIL";
                returnMsg = downloadBillResData.getReturn_msg();
            }
        }
        catch (StreamException e) {
            if (downloadBillServiceResponseString.equals(null) || downloadBillServiceResponseString.equals("")) {
                this.setResult("Case4:\u5bf9\u8d26\u5355API\u7cfb\u7edf\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a", "logTypeError");
                resultListener.onDownloadBillFail(downloadBillServiceResponseString);
            } else {
                this.setResult("Case3:\u5bf9\u8d26\u5355API\u7cfb\u7edf\u6210\u529f\u8fd4\u56de\u6570\u636e", "logTypeInfo");
                resultListener.onDownloadBillSuccess(downloadBillServiceResponseString);
            }
            returnCode = "SUCCESS";
        }
        finally {
            ReportReqData reportReqData = new ReportReqData(downloadBillReqData.getDevice_info(), Configure.DOWNLOAD_BILL_API, (int)totalTimeCost, returnCode, returnMsg, "", "", "", "", Configure.getIP());
            if (Configure.isUseThreadToDoReport()) {
                ReporterFactory.getReporter(reportReqData).run();
                long timeAfterReport = System.currentTimeMillis();
                Util.log("pay+report\u603b\u8017\u65f6\uff08\u5f02\u6b65\u65b9\u5f0f\u4e0a\u62a5\uff09\uff1a" + (timeAfterReport - costTimeStart) + "ms");
            } else {
                ReportService.request(reportReqData);
                long timeAfterReport = System.currentTimeMillis();
                Util.log("pay+report\u603b\u8017\u65f6\uff08\u540c\u6b65\u65b9\u5f0f\u4e0a\u62a5\uff09\uff1a" + (timeAfterReport - costTimeStart) + "ms");
            }
        }
    }

    public void setDownloadBillService(DownloadBillService service) {
        this.downloadBillService = service;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        DownloadBillBusiness.result = result;
    }

    public void setResult(String result, String type) {
        this.setResult(result);
        log.log(type, result);
    }

    public static interface ResultListener {
        public void onFailByReturnCodeError(DownloadBillResData var1);

        public void onFailByReturnCodeFail(DownloadBillResData var1);

        public void onDownloadBillFail(String var1);

        public void onDownloadBillSuccess(String var1);
    }
}

