/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.common.registry;

import com.tencent.polaris.common.registry.BootConfigHandler;
import com.tencent.polaris.factory.config.ConfigurationImpl;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseBootConfigHandler
implements BootConfigHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseBootConfigHandler.class);

    @Override
    public void handle(Map<String, String> parameters, ConfigurationImpl configuration) {
        int timeout = 0;
        String timeoutStr = parameters.get("timeout");
        if (null != timeoutStr && timeoutStr.length() > 0) {
            try {
                timeout = Integer.parseInt(timeoutStr);
            }
            catch (Exception e) {
                LOGGER.info("[Common] fail to convert ttlStr {}", (Object)timeoutStr, (Object)e);
            }
        }
        if (timeout > 0) {
            configuration.getGlobal().getAPI().setTimeout((long)timeout);
        }
        Boolean persistEnable = null;
        String persistEnableStr = parameters.get("persist_enable");
        if (null != persistEnableStr && persistEnableStr.length() > 0) {
            persistEnable = Boolean.parseBoolean(persistEnableStr);
        }
        if (null != persistEnable) {
            configuration.getConsumer().getLocalCache().setPersistEnable(persistEnable);
        }
    }
}

