/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.common.parser;

import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.common.parser.QueryParser;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaObjectQueryParser
implements QueryParser {
    private static final Pattern ARRAY_PATTERN = Pattern.compile("^.+\\[[0-9]+\\]");
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaObjectQueryParser.class);
    private static final String PREFIX_PARAM = "param";
    private static final String PREFIX_PARAM_ARRAY = "param[";

    @Override
    public String name() {
        return "JavaObject";
    }

    @Override
    public Optional<String> parse(String restKey, Object[] parameters) {
        int index = -1;
        if (restKey.startsWith(PREFIX_PARAM)) {
            index = 0;
            restKey = restKey.substring(PREFIX_PARAM.length());
        } else if (restKey.startsWith(PREFIX_PARAM_ARRAY)) {
            int endInx = restKey.indexOf(93);
            String indexValue = restKey.substring(1, endInx);
            index = Integer.parseInt(indexValue);
            restKey = restKey.substring(endInx + 1);
        } else {
            LOGGER.warn("invalid object expression for {}", (Object)restKey);
        }
        if (index == -1 || parameters.length <= index) {
            return Optional.empty();
        }
        Object targetValue = parameters[index];
        if (restKey.length() == 0) {
            if (Objects.isNull(targetValue)) {
                return Optional.empty();
            }
            return Optional.ofNullable(Objects.toString(targetValue));
        }
        if (!StringUtils.isBlank((String)(restKey = restKey.substring(1)))) {
            String[] tokens;
            for (String token : tokens = restKey.split("\\.")) {
                if (null == targetValue) break;
                targetValue = JavaObjectQueryParser.resolveValue(token, targetValue);
            }
        }
        if (Objects.isNull(targetValue)) {
            return Optional.empty();
        }
        return Optional.ofNullable(Objects.toString(targetValue));
    }

    private static Object resolveValue(String path, Object value) {
        Collection collectionValues;
        String fieldName = path;
        int index = -1;
        Matcher matcher = ARRAY_PATTERN.matcher(path);
        if (matcher.matches()) {
            fieldName = path.substring(0, path.indexOf(91));
            String indexStr = path.substring(path.indexOf(91) + 1, path.lastIndexOf(93));
            index = Integer.parseInt(indexStr);
        }
        Object objectByFieldName = null;
        if (value.getClass().isAssignableFrom(Map.class)) {
            Map mapValues = (Map)value;
            objectByFieldName = mapValues.get(fieldName);
        } else {
            try {
                objectByFieldName = JavaObjectQueryParser.getObjectByFieldName(value, fieldName);
            }
            catch (Exception e) {
                LOGGER.error("[POLARIS] fail to resolve field {} by class {}", new Object[]{fieldName, value.getClass().getCanonicalName(), e});
            }
        }
        if (index < 0 || objectByFieldName == null) {
            return objectByFieldName;
        }
        Class<Collection> targetClazz = objectByFieldName.getClass();
        if (targetClazz.isArray()) {
            Class<?> componentType = targetClazz.getComponentType();
            if (!componentType.isPrimitive()) {
                Object[] values = (Object[])objectByFieldName;
                if (values.length > index) {
                    return values[index];
                }
                return null;
            }
            return JavaObjectQueryParser.processPrimitiveArray(componentType, objectByFieldName, index);
        }
        if (targetClazz.isAssignableFrom(List.class)) {
            List listValues = (List)objectByFieldName;
            if (listValues.size() > index) {
                return listValues.get(index);
            }
            return null;
        }
        if (targetClazz.isAssignableFrom(Collection.class) && (collectionValues = (Collection)objectByFieldName).size() > index) {
            Iterator iterator = collectionValues.iterator();
            Object nextValue = null;
            for (int i = 0; i < index; ++i) {
                nextValue = iterator.next();
            }
            return nextValue;
        }
        return null;
    }

    private static Object processPrimitiveArray(Class<?> componentType, Object object, int index) {
        if (componentType == Integer.TYPE) {
            int[] values = (int[])object;
            if (values.length > index) {
                return values[index];
            }
            return null;
        }
        if (componentType == Long.TYPE) {
            long[] values = (long[])object;
            if (values.length > index) {
                return values[index];
            }
            return null;
        }
        if (componentType == Double.TYPE) {
            double[] values = (double[])object;
            if (values.length > index) {
                return values[index];
            }
            return null;
        }
        if (componentType == Short.TYPE) {
            short[] values = (short[])object;
            if (values.length > index) {
                return values[index];
            }
            return null;
        }
        if (componentType == Float.TYPE) {
            float[] values = (float[])object;
            if (values.length > index) {
                return Float.valueOf(values[index]);
            }
            return null;
        }
        if (componentType == Boolean.TYPE) {
            boolean[] values = (boolean[])object;
            if (values.length > index) {
                return values[index];
            }
            return null;
        }
        if (componentType == Byte.TYPE) {
            byte[] values = (byte[])object;
            if (values.length > index) {
                return values[index];
            }
            return null;
        }
        if (componentType == Character.TYPE) {
            char[] values = (char[])object;
            if (values.length > index) {
                return Character.valueOf(values[index]);
            }
            return null;
        }
        return null;
    }

    private static Object getObjectByFieldName(Object target, String fieldName) throws Exception {
        Field field = target.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(target);
    }
}

