/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.util;

import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TrScheduledExecutor
extends ScheduledThreadPoolExecutor {
    public TrScheduledExecutor(final String threadName) {
        super(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, threadName);
            }
        });
    }

    public int pendingTaskCount() {
        return this.getQueue().size();
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        return new FutureDecorator<V>(task);
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
        return new FutureDecorator<V>(task);
    }

    class FutureDecorator<V>
    implements RunnableScheduledFuture<V> {
        final RunnableScheduledFuture<V> delegate;

        FutureDecorator(RunnableScheduledFuture<V> _delegate) {
            this.delegate = _delegate;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean isok = this.delegate.cancel(mayInterruptIfRunning);
            if (isok) {
                TrScheduledExecutor.this.getQueue().remove(this);
            }
            return isok;
        }

        @Override
        public boolean isPeriodic() {
            return this.delegate.isPeriodic();
        }

        @Override
        public void run() {
            this.delegate.run();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.delegate.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.get(timeout, unit);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.delegate.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.delegate.compareTo(o);
        }
    }
}

