/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.util;

import com.taobao.remoting.util.ResourceInvalidException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;

public abstract class SharedResourcesInit<V> {
    private static final int RETRY_TIMES = 2;
    private static final String SINGLE_RSC_KEY = "single_resource";
    private ConcurrentHashMap<String, SimpleFutureTask> initRightSelect = new ConcurrentHashMap();

    public V getResource() throws ExecutionException, ResourceInvalidException, InterruptedException {
        if (!this.isSingletonResource()) {
            throw new UnsupportedOperationException();
        }
        return this.innerGetResource(SINGLE_RSC_KEY, null);
    }

    public V getResource(String key, Object attachment) throws ExecutionException, ResourceInvalidException, InterruptedException {
        if (this.isSingletonResource()) {
            throw new UnsupportedOperationException();
        }
        return this.innerGetResource(key, attachment);
    }

    private V innerGetResource(String key, Object attachment) throws ExecutionException, ResourceInvalidException, InterruptedException {
        Object resource = null;
        for (int i = 0; i < 2 && resource == null; ++i) {
            SimpleFutureTask initTask = this.initRightSelect.get(key);
            if (initTask == null && (initTask = this.initRightSelect.putIfAbsent(key, new SimpleFutureTask(key, attachment))) == null) {
                initTask = this.initRightSelect.get(key);
                initTask.run();
            }
            try {
                resource = initTask.get();
                if (null == resource) {
                    throw new ResourceInvalidException("\u521b\u5efa\u7684\u5171\u4eab\u8d44\u6e90[" + key + "]\u4e3aNULL.");
                }
                this.validate(resource);
                continue;
            }
            catch (ExecutionException e) {
                this.initRightSelect.remove(key, initTask);
                throw e;
            }
            catch (ResourceInvalidException e) {
                this.initRightSelect.remove(key, initTask);
                if (i + 1 < 2) {
                    resource = null;
                    continue;
                }
                throw e;
            }
        }
        return resource;
    }

    public List<String> keys() {
        if (this.isSingletonResource()) {
            return null;
        }
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.initRightSelect.keySet());
        return keys;
    }

    public Map<String, V> resourcesSnapshot() throws Exception {
        HashMap snapshot = new HashMap();
        for (Map.Entry<String, SimpleFutureTask> entry : this.initRightSelect.entrySet()) {
            String key = entry.getKey();
            Object resource = entry.getValue().get();
            try {
                this.validate(resource);
                snapshot.put(key, resource);
            }
            catch (ResourceInvalidException resourceInvalidException) {}
        }
        return snapshot;
    }

    protected abstract boolean isSingletonResource();

    protected V initResource() throws Exception {
        if (!this.isSingletonResource()) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    protected V keyedInitResource(String key, Object attachment) throws Exception {
        if (this.isSingletonResource()) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    protected abstract void validate(V var1) throws ResourceInvalidException;

    private class SimpleFutureTask {
        private final String key;
        private final Object attachment;
        private volatile boolean isDone = false;
        private V result;
        private ExecutionException exception;

        SimpleFutureTask(String _key, Object _attachment) {
            this.key = _key;
            this.attachment = _attachment;
        }

        public synchronized V get() throws InterruptedException, ExecutionException {
            while (!this.isDone) {
                this.wait();
            }
            if (null != this.exception) {
                throw this.exception;
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.result = SharedResourcesInit.this.isSingletonResource() ? SharedResourcesInit.this.initResource() : SharedResourcesInit.this.keyedInitResource(this.key, this.attachment);
            }
            catch (Exception e) {
                this.exception = new ExecutionException(e);
            }
            SimpleFutureTask simpleFutureTask = this;
            synchronized (simpleFutureTask) {
                this.isDone = true;
                this.notifyAll();
            }
        }
    }
}

