/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ReflectionUtil {
    public static Object getPrivateField(Object instance, String name) {
        Object result = null;
        Class<?> type = instance.getClass();
        do {
            try {
                Field f = type.getDeclaredField(name);
                f.setAccessible(true);
                result = f.get(instance);
            }
            catch (Exception e) {
                // empty catch block
            }
        } while (null == result && null != (type = type.getSuperclass()));
        return result;
    }

    public static void setPrivateField(Object instance, String name, Object value) {
        Field f = null;
        Class<?> type = instance.getClass();
        while (null == f) {
            try {
                f = type.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                if (null != (type = type.getSuperclass())) continue;
                throw new RuntimeException(e);
            }
        }
        f.setAccessible(true);
        try {
            f.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setStaticField(Class<?> type, String name, Object value) throws Exception {
        Field f = type.getDeclaredField(name);
        f.setAccessible(true);
        f.set(null, value);
    }

    public static <T> T defaultCreate(Class<T> type) throws Exception {
        Constructor<T> cf = type.getDeclaredConstructor(new Class[0]);
        cf.setAccessible(true);
        return cf.newInstance(new Object[0]);
    }

    public static Object invokeMemberFunction(Object obj, String name, Object[] args) {
        int paramCount = null == args ? 0 : args.length;
        Method func = null;
        for (Method f : obj.getClass().getDeclaredMethods()) {
            Class<?>[] paramTypes;
            if (!f.getName().equals(name) || (paramTypes = f.getParameterTypes()).length != paramCount) continue;
            boolean ismatch = false;
            for (int i = 0; i < paramTypes.length && paramTypes[i].isAssignableFrom(args[i].getClass()); ++i) {
            }
            if (!ismatch) continue;
            func = f;
            break;
        }
        func.setAccessible(true);
        try {
            return func.invoke(obj, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Method getPrivateMethod(Class<?> cl, String name, Class<?>[] argTypes, Class<?> returnType) {
        Method meth = null;
        try {
            meth = cl.getDeclaredMethod(name, argTypes);
            meth.setAccessible(true);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        if (meth.getReturnType() != returnType) {
            return null;
        }
        int mods = meth.getModifiers();
        return !Modifier.isStatic(mods) && Modifier.isPrivate(mods) ? meth : null;
    }

    public static Method getInstanceMethod(Class<?> cl, String name, Class<?>[] argTypes, Class<?> returnType) {
        Method meth = null;
        try {
            meth = cl.getDeclaredMethod(name, argTypes);
            meth.setAccessible(true);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        if (meth.getReturnType() != returnType) {
            return null;
        }
        int mods = meth.getModifiers();
        return !Modifier.isStatic(mods) && !Modifier.isAbstract(mods) ? meth : null;
    }
}

