/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.serialize.impl;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.ByteBuffer;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoSession;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.filter.codec.ProtocolDecoderAdapter;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.filter.codec.ProtocolDecoderOutput;
import com.taobao.remoting.impl.ConnectionRequest;
import com.taobao.remoting.impl.ConnectionResponse;
import com.taobao.remoting.impl.DefaultConnection;
import com.taobao.remoting.serialize.impl.ConnRequestSerialization;
import com.taobao.remoting.serialize.impl.ConnResponseSerialization;
import com.taobao.remoting.serialize.impl.DeserializeException;
import com.taobao.remoting.util.LoggerInit;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class RemotingProtocolDecoder
extends ProtocolDecoderAdapter {
    private static final String INVALID_PROTOCOL_HEADER_PREFFIX = "\u975e\u6cd5\u7684\u62a5\u6587\u5934\u5b57\u6bb5: ";
    private static final String BUFFER = CumulativeProtocolDecoder.class.getName() + ".Buffer";
    private ConnRequestSerialization reqSerialize = new ConnRequestSerialization();
    private ConnResponseSerialization rspSerialize = new ConnResponseSerialization();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        boolean usingSessionBuffer = true;
        ByteBuffer buf = (ByteBuffer)session.getAttribute(BUFFER);
        if (buf != null) {
            buf.put(in);
            buf.flip();
        } else {
            buf = in;
            usingSessionBuffer = false;
        }
        boolean keepRemaining = true;
        try {
            boolean decoded = true;
            while (decoded && buf.hasRemaining()) {
                int oldPos = buf.position();
                try {
                    decoded = this.doDecode(session, buf, out);
                    if (decoded) {
                        if (buf.position() != oldPos) continue;
                        throw new IllegalStateException("doDecode() can't return true when buffer is not consumed.");
                    }
                    buf.position(oldPos);
                }
                catch (IOException ioe) {
                    if (!ioe.getMessage().contains(INVALID_PROTOCOL_HEADER_PREFFIX)) continue;
                    keepRemaining = false;
                    break;
                }
            }
        }
        finally {
            if (buf.hasRemaining() && keepRemaining) {
                if (usingSessionBuffer) {
                    buf.compact();
                } else {
                    this.storeRemainingInSession(buf, session);
                }
            } else if (usingSessionBuffer) {
                this.removeSessionBuffer(session);
            }
        }
    }

    protected boolean doDecode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        int origonPos = in.position();
        if (in.remaining() < 14) {
            return false;
        }
        byte protocolVer = in.get();
        if (13 != protocolVer) {
            IOException ioe = new IOException(INVALID_PROTOCOL_HEADER_PREFFIX + protocolVer + ", " + session);
            LoggerInit.LOGGER.warn(ioe.getMessage(), ioe);
            throw ioe;
        }
        byte requestFlag = in.get();
        byte protocol = in.get();
        in.get();
        in.get();
        int conLength = in.getInt();
        byte appClassNameLength = in.get();
        int appLength = in.getInt();
        int expectedBodyLength = conLength + appClassNameLength + appLength;
        if (in.remaining() < expectedBodyLength) {
            in.position(origonPos);
            return false;
        }
        in.position(origonPos + 14 + expectedBodyLength);
        ByteArrayInputStream is = new ByteArrayInputStream(in.array(), origonPos, 14 + expectedBodyLength);
        if (0 == requestFlag) {
            ConnectionRequest request = null;
            try {
                request = this.reqSerialize.deserialize(is, protocol);
                out.write(request);
            }
            catch (DeserializeException ioe) {
                request = ioe.getRequest();
                if (null != request) {
                    ConnectionResponse resp = ConnectionResponse.getResponse(request);
                    resp.setResult(1);
                    resp.setErrorMsg("\u53cd\u5e8f\u5217\u5316\u4e1a\u52a1\u8bf7\u6c42\u65f6\u51fa\u73b0\u9519\u8bef:" + ioe.getMessage());
                    session.write(resp, null);
                }
                throw ioe;
            }
        }
        ConnectionResponse response = null;
        try {
            response = this.rspSerialize.deserialize(is, protocol, session);
            out.write(response);
        }
        catch (DeserializeException ioe) {
            response = null != ioe.getResponse() ? ioe.getResponse() : new ConnectionResponse();
            response.setResult(5);
            response.setThrowable(ioe);
            DefaultConnection conn = DefaultConnection.findBySession(session);
            conn.getClient().putResponse(response);
            throw ioe;
        }
        return true;
    }

    @Override
    public void dispose(IoSession session) throws Exception {
        this.removeSessionBuffer(session);
    }

    private void removeSessionBuffer(IoSession session) {
        ByteBuffer buf = (ByteBuffer)session.removeAttribute(BUFFER);
        if (buf != null) {
            buf.release();
        }
    }

    private void storeRemainingInSession(ByteBuffer buf, IoSession session) {
        ByteBuffer remainingBuf = ByteBuffer.allocate(buf.capacity());
        remainingBuf.setAutoExpand(true);
        remainingBuf.order(buf.order());
        remainingBuf.put(buf);
        session.setAttribute(BUFFER, remainingBuf);
    }
}

