/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.serialize.impl;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoSession;
import com.taobao.remoting.Remoting;
import com.taobao.remoting.impl.ConnectionRequest;
import com.taobao.remoting.impl.ConnectionResponse;
import com.taobao.remoting.impl.DefaultClient;
import com.taobao.remoting.impl.DefaultConnection;
import com.taobao.remoting.serialize.CustomSerialization;
import com.taobao.remoting.serialize.DefaultSerialization;
import com.taobao.remoting.serialize.SerializationUtil;
import com.taobao.remoting.serialize.impl.DeserializeException;
import com.taobao.remoting.serialize.impl.SliceOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ConnResponseSerialization
implements CustomSerialization<ConnectionResponse> {
    private static final int IDX_APPTYPE = 9;
    private static final CustomSerialization<Object> defaultSerialize = new DefaultSerialization();

    private static CustomSerialization<Object> getSerial(String type) {
        Remoting.serialUtil();
        CustomSerialization<Object> result = SerializationUtil.getCustom(type);
        if (null == result) {
            result = defaultSerialize;
        }
        return result;
    }

    @Override
    public void serialize(ConnectionResponse response, byte protocol, OutputStream bout) throws IOException {
        Object appObject = response.getAppResponse();
        String appType = null != appObject ? appObject.getClass().getName() : "";
        SliceOutputStream out = (SliceOutputStream)bout;
        byte[] header = new byte[]{13, 1, protocol, 0, 0};
        bout.write(header);
        out.skipInt("connLength");
        bout.write((byte)appType.length());
        out.skipInt("appLength");
        int curSize = out.size();
        protocol = response.getSerializeProtocol();
        defaultSerialize.serialize(response, protocol, out);
        int connLength = out.size() - curSize;
        out.writeSkippedInt("connLength", connLength);
        out.write(appType.getBytes());
        curSize = out.size();
        ConnResponseSerialization.getSerial(appType).serialize(appObject, protocol, out);
        int appLength = out.size() - curSize;
        out.writeSkippedInt("appLength", appLength);
    }

    @Override
    public ConnectionResponse deserialize(InputStream is, byte protocol) throws DeserializeException {
        return this.deserialize(is, protocol, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionResponse deserialize(InputStream is, byte protocol, IoSession session) throws DeserializeException {
        ConnectionResponse response = null;
        try {
            Object appResponse;
            byte[] headers = new byte[14];
            is.read(headers);
            int appTypeLen = headers[9] & 0xFF;
            response = (ConnectionResponse)defaultSerialize.deserialize(is, protocol);
            if (0 == appTypeLen) {
                response.setSerializeProtocol(protocol);
                response.setAppResponse(null);
                return response;
            }
            byte[] tmp = new byte[appTypeLen];
            is.read(tmp);
            String appType = new String(tmp);
            ClassLoader requestTccl = this.getRequestClassLoader(response, session);
            ClassLoader currentTCCL = Thread.currentThread().getContextClassLoader();
            if (requestTccl == null || requestTccl == currentTCCL) {
                appResponse = ConnResponseSerialization.getSerial(appType).deserialize(is, protocol);
            } else {
                try {
                    Thread.currentThread().setContextClassLoader(requestTccl);
                    appResponse = ConnResponseSerialization.getSerial(appType).deserialize(is, protocol);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(currentTCCL);
                }
            }
            response.setSerializeProtocol(protocol);
            response.setAppResponse(appResponse);
            return response;
        }
        catch (IOException ioe) {
            throw new DeserializeException(ioe, response);
        }
    }

    private ClassLoader getRequestClassLoader(ConnectionResponse response, IoSession session) {
        if (session == null) {
            return null;
        }
        DefaultConnection conn = DefaultConnection.findBySession(session);
        if (conn == null) {
            return null;
        }
        DefaultClient client = (DefaultClient)conn.getClient();
        if (client == null) {
            return null;
        }
        long requestId = response.getRequestId();
        ConnectionRequest connRequest = client.getPendingRequest(requestId);
        if (connRequest == null) {
            return null;
        }
        return connRequest.getClassLoader();
    }
}

