/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.serialize.impl;

import com.taobao.remoting.Remoting;
import com.taobao.remoting.impl.ConnectionRequest;
import com.taobao.remoting.serialize.CustomSerialization;
import com.taobao.remoting.serialize.DefaultSerialization;
import com.taobao.remoting.serialize.SerializationUtil;
import com.taobao.remoting.serialize.impl.DeserializeException;
import com.taobao.remoting.serialize.impl.SliceOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ConnRequestSerialization
implements CustomSerialization<ConnectionRequest> {
    private static final int IDX_DIRECTION = 3;
    private static final int IDX_APPTYPE = 9;
    private static final CustomSerialization<Object> defaultSerial = new DefaultSerialization();

    private static CustomSerialization<Object> getSerial(String type) {
        Remoting.serialUtil();
        CustomSerialization<Object> result = SerializationUtil.getCustom(type);
        if (null == result) {
            result = defaultSerial;
        }
        return result;
    }

    @Override
    public void serialize(ConnectionRequest request, byte protocol, OutputStream out) throws IOException {
        Object appRequest = request.getAppRequest();
        String appType = null != appRequest ? appRequest.getClass().getName() : "";
        SliceOutputStream bout = (SliceOutputStream)out;
        byte[] header = new byte[]{13, 0, protocol, request.getDirection(), 0};
        bout.write(header);
        bout.skipInt("connLength");
        bout.write((byte)appType.length());
        bout.skipInt("appLength");
        int curSize = bout.size();
        defaultSerial.serialize(request, protocol, bout);
        bout.writeSkippedInt("connLength", bout.size() - curSize);
        bout.write(appType.getBytes());
        curSize = bout.size();
        ConnRequestSerialization.getSerial(appType).serialize(appRequest, protocol, bout);
        bout.writeSkippedInt("appLength", bout.size() - curSize);
    }

    @Override
    public ConnectionRequest deserialize(InputStream is, byte protocol) throws DeserializeException {
        ConnectionRequest request = null;
        try {
            byte[] headers = new byte[14];
            is.read(headers);
            byte direction = headers[3];
            int appTypeLen = headers[9] & 0xFF;
            request = (ConnectionRequest)defaultSerial.deserialize(is, protocol);
            request.setDirection(direction);
            request.setSerializeProtocol(protocol);
            if (0 == appTypeLen) {
                request.setSerializeProtocol(protocol);
                request.setAppRequest(null);
                return request;
            }
            byte[] tmp = new byte[appTypeLen];
            is.read(tmp);
            String appType = new String(tmp);
            Object appRequest = ConnRequestSerialization.getSerial(appType).deserialize(is, protocol);
            request.setSerializeProtocol(protocol);
            request.setAppRequest(appRequest);
            return request;
        }
        catch (IOException ioe) {
            throw new DeserializeException(ioe, request);
        }
    }
}

