/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl.socks;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.ByteBuffer;
import com.taobao.remoting.impl.NetUtil;
import com.taobao.remoting.impl.socks.SocksResponsePackage;
import java.io.UnsupportedEncodingException;

public class SocksConnectResponse
implements SocksResponsePackage {
    public int version;
    public int rep;
    public int rsv;
    public int atyp;
    public String addr;
    public int port;

    public static SocksConnectResponse decode(ByteBuffer buf) {
        buf.mark();
        SocksConnectResponse response = new SocksConnectResponse();
        if (buf.remaining() < 4) {
            return null;
        }
        response.version = buf.get() & 0xFF;
        response.rep = buf.get() & 0xFF;
        response.rsv = buf.get() & 0xFF;
        response.atyp = buf.get() & 0xFF;
        if (response.atyp == 1) {
            if (buf.remaining() < 4) {
                buf.reset();
                return null;
            }
            response.addr = NetUtil.intToIpAddress(buf.getInt());
        } else if (response.atyp == 4) {
            if (buf.remaining() < 16) {
                buf.reset();
                return null;
            }
            byte[] tmp = new byte[16];
            buf.get(tmp);
            response.addr = NetUtil.bytesToIpAddress(tmp, 0, 16);
        } else if (response.atyp == 3) {
            if (!buf.hasRemaining()) {
                buf.reset();
                return null;
            }
            int length = buf.get() & 0xFF;
            if (buf.remaining() < length) {
                buf.reset();
                return null;
            }
            byte[] bytes = new byte[length];
            buf.get(bytes);
            try {
                response.addr = new String(bytes, "ISO8859-1");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        if (buf.remaining() < 2) {
            buf.reset();
            return null;
        }
        response.port = buf.getUnsignedShort();
        return response;
    }

    public String toString() {
        return "SocksConnectResponse [version=" + this.version + ", rep=" + this.rep + ", rsv=" + this.rsv + ", atyp=" + this.atyp + ", addr=" + this.addr + ", port=" + this.port + "]";
    }
}

