/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl.socks;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.ByteBuffer;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoFilter;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoFilterAdapter;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoSession;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.support.BaseIoSession;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.filter.codec.ProtocolDecoderOutput;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.transport.socket.nio.SocketConnectorConfig;
import com.alibaba.cs.shaded.org.slf4j.Logger;
import com.alibaba.cs.shaded.org.slf4j.LoggerFactory;
import com.taobao.remoting.impl.NetUtil;
import com.taobao.remoting.impl.socks.Socks5CommandStatus;
import com.taobao.remoting.impl.socks.Socks5Decoder;
import com.taobao.remoting.impl.socks.SocksCmdRequest;
import com.taobao.remoting.impl.socks.SocksConnectResponse;
import com.taobao.remoting.impl.socks.SocksInit;
import com.taobao.remoting.impl.socks.SocksInitOk;
import com.taobao.remoting.impl.socks.SocksPackage;
import com.taobao.remoting.impl.socks.SocksRequestPackage;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Socks5IoHandler
extends IoFilterAdapter {
    static final Logger log = LoggerFactory.getLogger(Socks5IoHandler.class);
    static final int IPv6_LEN = 16;
    public static final int IPV4 = 1;
    public static final int DOMAIN = 3;
    public static final int IPV6 = 4;
    private static final int SOCKS5_VERSION = 5;
    private static final int CMD_CONNECT = 1;
    private long startConnect = System.currentTimeMillis();
    private StateHodler state;
    private SocketAddress destinationAddress;
    private Socks5Decoder decoder;
    private SocketConnectorConfig cfg;
    private IoSession session;
    private static volatile Thread checkConnectTimeoutThread;
    private static ConcurrentMap<Socks5IoHandler, Socks5IoHandler> clients;

    public Socks5IoHandler(StateHodler stateHodler, SocketAddress destinationAddress, SocketConnectorConfig cfg) {
        this.decoder = new Socks5Decoder(stateHodler);
        this.state = stateHodler;
        this.destinationAddress = destinationAddress;
        this.cfg = cfg;
        clients.put(this, this);
        Socks5IoHandler.tryStartConnectTimeoutThread();
    }

    private static synchronized void tryStartConnectTimeoutThread() {
        if (checkConnectTimeoutThread != null) {
            return;
        }
        checkConnectTimeoutThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    for (Map.Entry entry : clients.entrySet()) {
                        if (entry == null) continue;
                        ((Socks5IoHandler)entry.getKey()).checkConnectTimeout();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        }, "tbremoting-socks-check-connect-timeout-thread");
        checkConnectTimeoutThread.setDaemon(true);
        checkConnectTimeoutThread.start();
    }

    protected void checkConnectTimeout() {
        if (this.cfg.getConnectTimeoutMillis() <= 0L) {
            return;
        }
        if (System.currentTimeMillis() - this.startConnect >= this.cfg.getConnectTimeoutMillis()) {
            clients.remove(this);
            if (this.session != null) {
                this.session.close("timeout");
            }
        }
    }

    @Override
    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        super.sessionCreated(nextFilter, session);
        this.session = session;
    }

    @Override
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        super.sessionClosed(nextFilter, session);
        clients.remove(this);
    }

    @Override
    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
        clients.remove(this);
        session.close(cause.getMessage());
        log.error("", cause);
        super.exceptionCaught(nextFilter, session, cause);
    }

    @Override
    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        SocksInit socksInit = new SocksInit();
        log.debug("start socks hand shake,send first {}", (Object)socksInit);
        session.write(this.encode(session, socksInit));
    }

    public ByteBuffer encode(IoSession session, SocksRequestPackage message) throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(128);
        buf.setAutoExpand(true);
        SocksRequestPackage socksPackage = message;
        socksPackage.encode(buf);
        buf.flip();
        return buf;
    }

    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (!(message instanceof ByteBuffer)) {
            nextFilter.messageReceived(session, message);
            return;
        }
        if (this.state.state == 3) {
            throw new IllegalStateException("socks connect failed!");
        }
        if (this.state.state == 2) {
            super.messageReceived(nextFilter, session, message);
            return;
        }
        SimpleProtocolDecoderOutput out = new SimpleProtocolDecoderOutput(session, nextFilter);
        ByteBuffer buf = (ByteBuffer)message;
        this.decoder.decode(session, buf, out);
        List<Object> list = out.getMessagQueue();
        for (Object object : list) {
            if (object instanceof SocksPackage) {
                this.socksMessageReceived(nextFilter, session, object);
                continue;
            }
            super.messageReceived(nextFilter, session, message);
        }
    }

    public void socksMessageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        log.debug("current stsate is {},receive message {}", (Object)this.state.state, message);
        if (this.state.state == 0) {
            if (!(message instanceof SocksInitOk)) {
                throw new IllegalStateException("expect reponse " + SocksInitOk.class + " when INIT,but actual is " + message);
            }
            SocksInitOk initOk = (SocksInitOk)message;
            log.debug("receive initok {}", (Object)initOk);
            this.state.state = 1;
            this.sendConnectRequest(session);
            return;
        }
        if (this.state.state == 1) {
            if (!(message instanceof SocksConnectResponse)) {
                throw new IllegalStateException("expect reponse " + SocksInitOk.class + " when AUTHED,but actual is " + message);
            }
            SocksConnectResponse connectResponse = (SocksConnectResponse)message;
            log.debug("receive connect response {}", (Object)connectResponse);
            if (connectResponse.rep != Socks5CommandStatus.SUCCESS.byteValue()) {
                this.state.state = 3;
                String reason = "";
                reason = connectResponse.rep <= Socks5CommandStatus.ADDRESS_UNSUPPORTED.byteValue() ? Socks5CommandStatus.valueOf((byte)connectResponse.rep).toString() : "unknown status code " + connectResponse.rep;
                log.info("connect by socks5 proxy failed!,the reason is {}", (Object)reason);
                String execeptionMsg = "socks connect failed for reason " + reason;
                throw new IllegalStateException(execeptionMsg);
            }
            this.state.state = 2;
            clients.remove(this);
            super.sessionOpened(nextFilter, session);
            return;
        }
    }

    private void sendConnectRequest(IoSession session) throws Exception {
        String rhost;
        int addrType;
        SocksCmdRequest cmd = new SocksCmdRequest();
        cmd.version = 5;
        cmd.cmd = 1;
        InetSocketAddress raddr = (InetSocketAddress)this.destinationAddress;
        if (raddr.isUnresolved()) {
            addrType = 3;
            rhost = raddr.getHostString();
        } else {
            rhost = raddr.getAddress().getHostAddress();
            if (NetUtil.isValidIpV4Address(rhost)) {
                addrType = 1;
            } else if (NetUtil.isValidIpV6Address(rhost)) {
                addrType = 4;
            } else {
                throw new IllegalStateException("unknown address type: " + rhost);
            }
        }
        cmd.atype = addrType;
        cmd.addr = rhost;
        cmd.port = raddr.getPort();
        log.debug("sends socks5 connect cmd {}", (Object)cmd);
        session.write(this.encode(session, cmd));
    }

    static {
        clients = new ConcurrentHashMap<Socks5IoHandler, Socks5IoHandler>();
    }

    public static class StateHodler {
        public static final int INIT = 0;
        public static final int AUTHED = 1;
        public static final int CONNECTED = 2;
        public static final int ERROR = 3;
        int state = 0;
    }

    public class SimpleProtocolDecoderOutput
    implements ProtocolDecoderOutput {
        private final IoFilter.NextFilter nextFilter;
        private final IoSession session;
        private final List<Object> messageQueue = new ArrayList<Object>();

        public SimpleProtocolDecoderOutput(IoSession session, IoFilter.NextFilter nextFilter) {
            this.nextFilter = nextFilter;
            this.session = session;
        }

        @Override
        public void write(Object message) {
            this.messageQueue.add(message);
            if (this.session instanceof BaseIoSession) {
                ((BaseIoSession)this.session).increaseReadMessages();
            }
        }

        @Override
        public void flush() {
        }

        public List<Object> getMessagQueue() {
            return this.messageQueue;
        }
    }
}

