/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl;

import com.alibaba.cs.shaded.com.alibaba.org.apache.commons.pool.PoolableObjectFactory;
import com.alibaba.cs.shaded.com.alibaba.org.apache.commons.pool.impl.GenericObjectPool;
import com.taobao.remoting.Client;
import com.taobao.remoting.ClientManager;
import com.taobao.remoting.IOEventListener;
import com.taobao.remoting.RemotingException;
import com.taobao.remoting.impl.ClientConnectionFactory;
import com.taobao.remoting.impl.ClientKeyUtil;
import com.taobao.remoting.impl.FailedClientFuture;
import com.taobao.remoting.util.ConnectionUrl;
import com.taobao.remoting.util.LoggerInit;
import com.taobao.remoting.util.ResourceInvalidException;
import com.taobao.remoting.util.SharedResourcesInit;
import com.taobao.remoting.util.UnsafeCast;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

class RepositoryManager {
    private final ConnectionFactoryFactory factoryFactory;
    private final SingleClientFutureRepository singleClientFutureRepo = new SingleClientFutureRepository();
    private final ClientPoolRepository clientPoolRepo = new ClientPoolRepository();

    public RepositoryManager() {
        this.factoryFactory = new ConnectionFactoryFactory();
    }

    ClientConnectionFactory getConnectionFactory(String appName) {
        while (true) {
            try {
                return (ClientConnectionFactory)this.factoryFactory.getResource(appName, null);
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    Map<String, ClientConnectionFactory> clientFactorySnapshot() throws Exception {
        return this.factoryFactory.resourcesSnapshot();
    }

    /*
     * Loose catch block
     */
    ClientManager.ClientFuture getSingleClientAsync(String singleClientKey, List<IOEventListener> listeners) {
        while (true) {
            try {
                return (ClientManager.ClientFuture)this.singleClientFutureRepo.getResource(singleClientKey, listeners);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (ExecutionException ee) {
                return new FailedClientFuture("", new RemotingException(ee.getMessage(), ee.getCause()));
            }
            break;
        }
        catch (ResourceInvalidException e) {
            return new FailedClientFuture("", (RemotingException)e.getCause());
        }
    }

    String getClientPoolKey(String appName, String url) {
        return this.clientPoolRepo.getPoolKey(appName, url);
    }

    GenericObjectPool getClientPool(String clientPoolKey, List<IOEventListener> listeners) throws Exception {
        return (GenericObjectPool)this.clientPoolRepo.getResource(clientPoolKey, listeners);
    }

    class PoolableClientFactory
    implements PoolableObjectFactory {
        private final String url;
        private final String appName;
        private final List<IOEventListener> listeners;
        private ClientConnectionFactory factory;

        PoolableClientFactory(String _url, String _appName, List<IOEventListener> _listeners) {
            this.url = _url;
            this.appName = _appName;
            this.listeners = _listeners;
            try {
                this.factory = RepositoryManager.this.getConnectionFactory(this.appName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public Object makeObject() throws RemotingException, InterruptedException {
            return this.factory.createClient(this.url, null, this.listeners);
        }

        @Override
        public void destroyObject(Object client) {
            ((Client)client).destroy("PoolableClientFactory.destroyObject()");
        }

        @Override
        public boolean validateObject(Object client) {
            return null != client && ((Client)client).isConnected();
        }

        @Override
        public void activateObject(Object connection) {
        }

        @Override
        public void passivateObject(Object connection) {
        }
    }

    private class ClientPoolRepository
    extends SharedResourcesInit<GenericObjectPool> {
        private ClientPoolRepository() {
        }

        @Override
        protected boolean isSingletonResource() {
            return false;
        }

        @Override
        protected GenericObjectPool keyedInitResource(String poolKey, Object attachment) {
            String[] temp = this.parsePoolKey(poolKey);
            String appName = temp[0];
            String url = temp[1];
            ConnectionUrl urlObj = ConnectionUrl.get(url);
            int count = Integer.parseInt(urlObj.getProperty("_CONNECTIONNUM"));
            List listeners = (List)UnsafeCast.cast(attachment);
            GenericObjectPool clientPool = new GenericObjectPool(new PoolableClientFactory(url, appName, listeners));
            clientPool.setTestOnBorrow(true);
            clientPool.setMaxActive(count);
            clientPool.setMaxIdle(-1);
            clientPool.setMinIdle(-1);
            try {
                for (int i = 0; i < count; ++i) {
                    clientPool.addObject();
                }
            }
            catch (Exception e) {
                LoggerInit.LOGGER.error("\u9884\u5148\u521b\u5efa\u8fde\u63a5\u6c60\u8fde\u63a5\u5931\u8d25[" + url + "], " + e.getMessage());
            }
            return clientPool;
        }

        @Override
        protected void validate(GenericObjectPool clientPool) throws ResourceInvalidException {
            if (null == clientPool) {
                throw new ResourceInvalidException(new NullPointerException());
            }
        }

        private String getPoolKey(String appName, String url) {
            return appName + "#" + url;
        }

        private String[] parsePoolKey(String clientKey) {
            return clientKey.split("#");
        }
    }

    private class SingleClientFutureRepository
    extends SharedResourcesInit<ClientManager.ClientFuture> {
        private SingleClientFutureRepository() {
        }

        @Override
        protected boolean isSingletonResource() {
            return false;
        }

        @Override
        protected ClientManager.ClientFuture keyedInitResource(String clientKey, Object attachment) {
            Object[] tmp = ClientKeyUtil.parseClientKey(clientKey);
            String appName = (String)tmp[0];
            String targetUrl = (String)tmp[1];
            InetSocketAddress localAddress = (InetSocketAddress)tmp[2];
            List listeners = (List)UnsafeCast.cast(attachment);
            ClientConnectionFactory factory = RepositoryManager.this.getConnectionFactory(appName);
            return factory.createClientAsync(targetUrl, localAddress, listeners);
        }

        @Override
        protected void validate(ClientManager.ClientFuture f) throws ResourceInvalidException {
            if (!f.isDone()) {
                return;
            }
            try {
                if (!f.get(0L).isConnected()) {
                    throw new ResourceInvalidException("\u8fde\u63a5[" + f.targetUrl() + "]\u5df2\u5173\u95ed.");
                }
            }
            catch (RemotingException re) {
                throw new ResourceInvalidException(re);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class ConnectionFactoryFactory
    extends SharedResourcesInit<ClientConnectionFactory> {
        private ConnectionFactoryFactory() {
        }

        @Override
        protected boolean isSingletonResource() {
            return false;
        }

        @Override
        protected void validate(ClientConnectionFactory factory) {
        }

        @Override
        protected ClientConnectionFactory keyedInitResource(String appName, Object attachment) {
            ClientConnectionFactory factory = new ClientConnectionFactory(appName);
            return factory;
        }
    }
}

