/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl;

import com.taobao.remoting.ClientManager;
import com.taobao.remoting.IOEventListener;
import com.taobao.remoting.Remoting;
import com.taobao.remoting.impl.ClientKeyUtil;
import com.taobao.remoting.impl.DefaultClientManager;
import com.taobao.remoting.util.ConnectionUrl;
import java.net.InetSocketAddress;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ReconnectManager {
    private Hashtable<String, ScheduledFuture<?>> tasks = new Hashtable();

    synchronized boolean addReconnectTask(String appName, String targetUrl, InetSocketAddress localAddress, List<IOEventListener> listeners) {
        if (!ConnectionUrl.isAutoReconnect(targetUrl)) {
            return false;
        }
        String taskKey = ClientKeyUtil.singleClientKey(appName, targetUrl, localAddress);
        if (this.tasks.containsKey(taskKey)) {
            return false;
        }
        Reconnect task = new Reconnect(taskKey, listeners);
        ScheduledFuture<?> future = DefaultClientManager.timer.scheduleWithFixedDelay(task, 0L, task.reconnectInterval, TimeUnit.MILLISECONDS);
        this.tasks.put(taskKey, future);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopAllTasks() {
        Hashtable<String, ScheduledFuture<?>> hashtable = this.tasks;
        synchronized (hashtable) {
            for (Map.Entry<String, ScheduledFuture<?>> entry : this.tasks.entrySet()) {
                entry.getValue().cancel(true);
            }
            this.tasks.clear();
        }
    }

    int taskSize() {
        return this.tasks.size();
    }

    private class Reconnect
    implements Runnable {
        private ClientManager.ClientFuture cf;
        private final String reconnectKey;
        private final List<IOEventListener> listeners;
        private final String appName;
        private final String targetUrl;
        private final InetSocketAddress localAddress;
        private final long reconnectInterval;

        Reconnect(String _reconnectKey, List<IOEventListener> _listeners) {
            if (null == _reconnectKey) {
                throw new IllegalArgumentException();
            }
            this.reconnectKey = _reconnectKey;
            this.listeners = _listeners;
            Object[] tmp = ClientKeyUtil.parseClientKey(this.reconnectKey);
            this.appName = (String)tmp[0];
            this.targetUrl = (String)tmp[1];
            this.localAddress = (InetSocketAddress)tmp[2];
            ConnectionUrl url = ConnectionUrl.get(this.targetUrl);
            this.reconnectInterval = Long.valueOf(url.getProperty("_AUTORECONNECT_SLEEPTIME"));
        }

        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Reconnect)) {
                return false;
            }
            Reconnect another = (Reconnect)obj;
            return another.reconnectKey.equals(this.reconnectKey);
        }

        boolean isConnected() {
            return null != this.cf && this.cf.isConnected();
        }

        boolean isConnectDone() {
            return null != this.cf && this.cf.isDone();
        }

        @Override
        public void run() {
            if (null == this.cf || this.cf.isDone() && !this.cf.isConnected()) {
                this.cf = Remoting.clientMgr().getAsync(this.appName, this.targetUrl, this.localAddress, this.listeners, null);
            } else if (this.cf.isConnected()) {
                ReconnectManager.this.tasks.remove(this.reconnectKey);
                throw new RuntimeException("\u8fde\u63a5\u6210\u529f");
            }
        }
    }
}

