/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl;

import com.taobao.remoting.RequestProcessor;
import com.taobao.remoting.locale.LogResources;
import com.taobao.remoting.util.LoggerInit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ProcessorUtil {
    private volatile ConcurrentHashMap<Class<?>, RequestProcessor<?>> processors = new ConcurrentHashMap();

    public ProcessorUtil() {
        this(null);
    }

    private ProcessorUtil(Map<Class<?>, RequestProcessor<?>> _processors) {
        if (null != _processors) {
            for (RequestProcessor<?> p : _processors.values()) {
                this.registerProcessor(p);
            }
        }
    }

    public void registerProcessor(RequestProcessor<?> processor) {
        if (processor.getExecutor() != processor.getExecutor()) {
            LoggerInit.LOGGER.error(LogResources.getLog("incorrectImplRequestProcessor", processor), new Exception());
            return;
        }
        if (null != this.processors.putIfAbsent(processor.interest(), processor)) {
            LoggerInit.LOGGER.warn("\u4e0d\u80fd\u91cd\u590d\u6ce8\u518cProcessor[" + processor.interest() + ", " + processor + "].", new Exception());
        }
    }

    public <T> RequestProcessor<T> removeProcessor(Class<T> appRequestClazz) {
        return this.processors.remove(appRequestClazz);
    }

    public void updateProcessors(Map<Class<?>, RequestProcessor<?>> newProcessors) {
        this.processors = new ProcessorUtil(newProcessors).processors;
    }

    public Map<Class<?>, RequestProcessor<?>> getProcessors() {
        return this.processors;
    }

    public <T> RequestProcessor<T> findProcessor(Class<T> appRequestClazz) {
        return this.processors.get(appRequestClazz);
    }
}

