/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.ConnectFuture;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IdleStatus;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoHandlerAdapter;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoSession;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.RuntimeIOException;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.WriteTimeoutException;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.support.AbstractIoFilterChain;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.transport.socket.nio.SocketAcceptor;
import com.taobao.remoting.ConnectCancelledException;
import com.taobao.remoting.Connection;
import com.taobao.remoting.IOEventListener;
import com.taobao.remoting.RequestProcessor;
import com.taobao.remoting.impl.ClientConnectionFactory;
import com.taobao.remoting.impl.ClientKeyUtil;
import com.taobao.remoting.impl.DefaultClient;
import com.taobao.remoting.impl.DefaultConnection;
import com.taobao.remoting.impl.DefaultConnectionFactory;
import com.taobao.remoting.locale.LogResources;
import com.taobao.remoting.util.ConnectionUrl;
import com.taobao.remoting.util.LoggerInit;
import java.util.List;

public class DefaultIoHandler
extends IoHandlerAdapter {
    private final DefaultConnectionFactory connFactory;

    DefaultIoHandler(DefaultConnectionFactory factory) {
        this.connFactory = factory;
    }

    private DefaultConnection createConnection(IoSession session) {
        DefaultConnection conn = DefaultConnection.findBySession(session);
        if (null == conn) {
            conn = new DefaultConnection(session, this.connFactory);
        }
        if (session.getService() instanceof SocketAcceptor) {
            new DefaultClient(session, null);
        }
        return conn;
    }

    @Override
    public void sessionOpened(IoSession session) throws Exception {
        if (session.getIdleTime(IdleStatus.READER_IDLE) <= 0) {
            session.setIdleTime(IdleStatus.READER_IDLE, 30);
        }
        DefaultConnection conn = this.createConnection(session);
        this.callConnectionOpenedListeners(conn, conn.getConnectionEvtListeners());
        this.callConnectionOpenedListeners(conn, this.connFactory.globalListeners);
    }

    @Override
    public void sessionClosed(IoSession session) {
        DefaultConnection conn = DefaultConnection.findBySession(session);
        this.callConnectionClosedListeners(conn, conn.getConnectionEvtListeners());
        this.callConnectionClosedListeners(conn, this.connFactory.globalListeners);
    }

    @Override
    public void sessionIdle(IoSession session, IdleStatus status) {
        DefaultConnection conn = DefaultConnection.findBySession(session);
        this.callConnectionIdleListeners(conn, conn.getConnectionEvtListeners());
        this.callConnectionIdleListeners(conn, this.connFactory.globalListeners);
    }

    @Override
    public void messageReceived(IoSession session, Object message) throws Exception {
        DefaultConnection conn = DefaultConnection.findBySession(session);
        conn.getMsgReceivedListener().messageReceived(conn, message);
    }

    @Override
    public void exceptionCaught(IoSession session, Throwable cause) {
        DefaultConnection conn = DefaultConnection.findBySession(session);
        if (cause instanceof WriteTimeoutException) {
            conn.close(cause.toString());
            LoggerInit.LOGGER.error(LogResources.getLog("connectionWriteTimeoutException", conn), cause);
        } else {
            LoggerInit.LOGGER.error(LogResources.getLog("connectionException", conn, cause), cause);
        }
    }

    private void callConnectionOpenedListeners(Connection connection, List<IOEventListener> listeners) {
        for (IOEventListener listener : listeners) {
            if (!(listener instanceof IOEventListener.ConnectionLifecycleListener)) continue;
            try {
                ((IOEventListener.ConnectionLifecycleListener)listener).connectionOpened(connection);
            }
            catch (Exception e) {
                LoggerInit.LOGGER.warn("", e);
            }
        }
    }

    private void callConnectionClosedListeners(Connection connection, List<IOEventListener> listeners) {
        for (IOEventListener listener : listeners) {
            if (!(listener instanceof IOEventListener.ConnectionLifecycleListener)) continue;
            try {
                ((IOEventListener.ConnectionLifecycleListener)listener).connectionClosed(connection);
            }
            catch (Exception e) {
                LoggerInit.LOGGER.warn("", e);
            }
        }
    }

    private void callConnectionIdleListeners(Connection connection, List<IOEventListener> listeners) {
        for (IOEventListener listener : listeners) {
            if (!(listener instanceof IOEventListener.ConnectionIdleListener)) continue;
            try {
                ((IOEventListener.ConnectionIdleListener)listener).connectionIdle(connection);
            }
            catch (Exception e) {
                LoggerInit.LOGGER.warn("", e);
            }
        }
    }

    static class ClientIoHandler
    extends DefaultIoHandler {
        private final String clientKey;
        private final List<IOEventListener> ioListeners;

        ClientIoHandler(ClientConnectionFactory ccf, String _clientKey, List<IOEventListener> _listeners) {
            super(ccf);
            this.clientKey = _clientKey;
            this.ioListeners = _listeners;
        }

        @Override
        public void sessionOpened(IoSession session) throws Exception {
            block6: {
                ConnectFuture cf = (ConnectFuture)session.getAttribute(AbstractIoFilterChain.CONNECT_FUTURE);
                try {
                    cf.getSession();
                }
                catch (RuntimeIOException ioe) {
                    Throwable cause = ioe.getCause();
                    if (null == cause || cause.getClass() != ConnectCancelledException.class) break block6;
                    session.close("ConnectionRequestCancelled");
                    throw (ConnectCancelledException)cause;
                }
            }
            String targetUrl = ClientKeyUtil.targetUrl(this.clientKey);
            int idleTimeout = ConnectionUrl.getIdleTimeout(targetUrl);
            if (0 < idleTimeout) {
                session.setIdleTime(IdleStatus.READER_IDLE, idleTimeout);
            }
            DefaultConnection connection = ((DefaultIoHandler)this).createConnection(session);
            new DefaultClient(session, this.clientKey);
            for (IOEventListener listener : this.ioListeners) {
                if (listener instanceof IOEventListener.ConnectionMsgReceivedListener) {
                    IOEventListener.ConnectionMsgReceivedListener msgListener = (IOEventListener.ConnectionMsgReceivedListener)listener;
                    for (RequestProcessor<?> p : msgListener.getProcessors().values()) {
                        connection.getMsgReceivedListener().registerProcessor(p);
                    }
                    continue;
                }
                connection.addConnectionEvtListener(listener);
            }
            super.sessionOpened(session);
        }
    }
}

