/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoFilter;
import com.taobao.remoting.Connection;
import com.taobao.remoting.ConnectionFactory;
import com.taobao.remoting.IOEventListener;
import com.taobao.remoting.RequestProcessor;
import com.taobao.remoting.impl.CL_IdleListener;
import com.taobao.remoting.impl.HeartBeatProcessor;
import com.taobao.remoting.impl.LCL_AliveSessionsListener;
import com.taobao.remoting.impl.LCL_onClose4PendingRequest;
import com.taobao.remoting.impl.ProcessorUtil;
import com.taobao.remoting.serialize.impl.RemotingProtocolCodecFilter;
import com.taobao.remoting.util.NamedThreadFactory;
import com.taobao.remoting.util.UnsafeCast;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public abstract class DefaultConnectionFactory
implements ConnectionFactory {
    public static final String CODEC_FILTER_NAME = "objectserialize";
    protected static final IoFilter CODEC_FILTER = new RemotingProtocolCodecFilter();
    protected static final int processorCount = Runtime.getRuntime().availableProcessors();
    protected static final Executor IO_THREAD_POOL = Executors.newCachedThreadPool(new NamedThreadFactory("", true));
    protected static final String DEFAULT_GROUP_NAME = "DEFAULT_GROUP";
    private ConcurrentHashMap<String, Set<Connection>> groups = new ConcurrentHashMap();
    IOEventListener.ConnectionLifecycleListener groupMaintainListener = new IOEventListener.ConnectionLifecycleListener(){

        @Override
        public void connectionOpened(Connection conn) {
            DefaultConnectionFactory.this.addConnectionToGroup0(conn, DefaultConnectionFactory.DEFAULT_GROUP_NAME);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionClosed(Connection conn) {
            ConcurrentHashMap concurrentHashMap = DefaultConnectionFactory.this.groups;
            synchronized (concurrentHashMap) {
                for (String group : DefaultConnectionFactory.this.groups()) {
                    DefaultConnectionFactory.this.removeConnectionFromGroup0(conn, group);
                }
                DefaultConnectionFactory.this.removeConnectionFromGroup0(conn, DefaultConnectionFactory.DEFAULT_GROUP_NAME);
            }
        }
    };
    CopyOnWriteArrayList<IOEventListener> globalListeners = new CopyOnWriteArrayList();
    private final ProcessorUtil globalProcessors = new ProcessorUtil();

    @Override
    public List<String> groups() {
        ArrayList<String> result = new ArrayList<String>(this.groups.keySet());
        result.remove(DEFAULT_GROUP_NAME);
        return result;
    }

    @Override
    public int connectionCountInGroup(String group) {
        Set<Connection> conns = this.groups.get(group);
        return null == conns ? 0 : conns.size();
    }

    @Override
    public boolean addConnectionToGroup(Connection connection, String groupName) {
        if (!this.checkParam(connection, groupName)) {
            return false;
        }
        this.addConnectionToGroup0(connection, groupName);
        return true;
    }

    @Override
    public boolean removeConnectionFromGroup(Connection connection, String groupName) {
        if (!this.checkParam(connection, groupName)) {
            return false;
        }
        this.removeConnectionFromGroup0(connection, groupName);
        return true;
    }

    @Override
    public List<Connection> groupConnectionSnapshot(String groupName) {
        if (!this.checkParam(null, groupName)) {
            return (List)UnsafeCast.cast(Collections.EMPTY_LIST);
        }
        return this.groupConnectionSnapshot0(groupName);
    }

    @Override
    public List<Connection> allConnectionSnapshot() {
        return this.groupConnectionSnapshot0(DEFAULT_GROUP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkParam(Connection connection, String groupName) {
        if (null != groupName && DEFAULT_GROUP_NAME.equals(groupName)) {
            return false;
        }
        if (null != connection) {
            ConcurrentHashMap<String, Set<Connection>> concurrentHashMap = this.groups;
            synchronized (concurrentHashMap) {
                Set<Connection> defaultGroup = this.groups.get(DEFAULT_GROUP_NAME);
                if (null == defaultGroup || !defaultGroup.contains(connection)) {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConnectionToGroup0(Connection connection, String groupName) {
        ConcurrentHashMap<String, Set<Connection>> concurrentHashMap = this.groups;
        synchronized (concurrentHashMap) {
            Set<Connection> group = this.groups.get(groupName);
            if (null == group) {
                group = new HashSet<Connection>();
                this.groups.put(groupName, group);
            }
            group.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnectionFromGroup0(Connection connection, String groupName) {
        ConcurrentHashMap<String, Set<Connection>> concurrentHashMap = this.groups;
        synchronized (concurrentHashMap) {
            Set<Connection> group = this.groups.get(groupName);
            if (null == group) {
                this.groups.remove(groupName);
                return;
            }
            group.remove(connection);
            if (group.isEmpty()) {
                this.groups.remove(groupName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Connection> groupConnectionSnapshot0(String groupName) {
        ArrayList<Connection> conns = new ArrayList<Connection>();
        ConcurrentHashMap<String, Set<Connection>> concurrentHashMap = this.groups;
        synchronized (concurrentHashMap) {
            Set<Connection> group = this.groups.get(groupName);
            if (null != group) {
                conns.addAll(group);
            }
        }
        return conns;
    }

    DefaultConnectionFactory() {
        this.addListener(this.groupMaintainListener);
        this.addListener(new CL_IdleListener());
        this.addListener(new LCL_AliveSessionsListener());
        this.addListener(new LCL_onClose4PendingRequest());
        this.registerProcessor(HeartBeatProcessor.instance);
    }

    @Override
    public final void addListener(IOEventListener listener) {
        this.globalListeners.add(listener);
    }

    @Override
    public final void removeListener(IOEventListener listener) {
        this.globalListeners.remove(listener);
    }

    @Override
    public void registerProcessor(RequestProcessor<?> processor) {
        this.globalProcessors.registerProcessor(processor);
    }

    @Override
    public void replaceProcessor(RequestProcessor<?> processor) {
        this.globalProcessors.removeProcessor(processor.interest());
        this.globalProcessors.registerProcessor(processor);
    }

    @Override
    public <T> RequestProcessor<T> removeProcessor(Class<T> appRequestClazz) {
        return this.globalProcessors.removeProcessor(appRequestClazz);
    }

    @Override
    public <T> RequestProcessor<T> findProcessor(Class<T> appRequestClazz) {
        return this.globalProcessors.findProcessor(appRequestClazz);
    }

    @Override
    public Map<Class<?>, RequestProcessor<?>> getProcessors() {
        return this.globalProcessors.getProcessors();
    }
}

