/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl;

import com.alibaba.cs.shaded.com.alibaba.org.apache.commons.pool.impl.GenericObjectPool;
import com.taobao.remoting.Client;
import com.taobao.remoting.ClientManager;
import com.taobao.remoting.Connection;
import com.taobao.remoting.IOEventListener;
import com.taobao.remoting.RemotingException;
import com.taobao.remoting.RequestProcessor;
import com.taobao.remoting.impl.ClientConnectionFactory;
import com.taobao.remoting.impl.ClientKeyUtil;
import com.taobao.remoting.impl.DefaultMsgListener;
import com.taobao.remoting.impl.ReconnectManager;
import com.taobao.remoting.impl.RepositoryManager;
import com.taobao.remoting.locale.LogResources;
import com.taobao.remoting.util.BackDoorDoggie;
import com.taobao.remoting.util.ConnectionUrl;
import com.taobao.remoting.util.LoggerInit;
import com.taobao.remoting.util.StringUtils;
import com.taobao.remoting.util.TrScheduledExecutor;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DefaultClientManager
extends ClientManager {
    public static final TrScheduledExecutor timer = new TrScheduledExecutor("com.taobao.remoting.TimerThread");
    final ReconnectManager reconnectMgr = new ReconnectManager();
    final RepositoryManager repoMgr = new RepositoryManager();

    @Override
    public void closeEnsureNoReconnect(String appName, String targetUrl) {
        for (Connection conn : this.getConnectionFactory(appName).allConnectionSnapshot()) {
            Client client = conn.getClient();
            if (!targetUrl.equals(client.getConnectionUrl())) continue;
            client.destroy("ClientManager.closeEnsureNoReconnect()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Client get(String appName, String targetUrl, InetSocketAddress localAddress, List<IOEventListener> listeners, Map<Class<?>, RequestProcessor<?>> processors) throws RemotingException, InterruptedException {
        ConnectionUrl urlObj = ConnectionUrl.get(targetUrl);
        List<IOEventListener> copyListeners = DefaultClientManager.copyListener(listeners, processors);
        int count = Integer.parseInt(urlObj.getProperty("_CONNECTIONNUM"));
        if (1 == count) {
            try {
                return this.getAsync(appName, targetUrl, localAddress, copyListeners, null).get(-1L);
            }
            catch (RemotingException e) {
                this.reconnectMgr.addReconnectTask(appName, targetUrl, localAddress, copyListeners);
                throw e;
            }
        }
        String key = this.repoMgr.getClientPoolKey(appName, targetUrl);
        try {
            GenericObjectPool clientPool;
            GenericObjectPool genericObjectPool = clientPool = this.repoMgr.getClientPool(key, copyListeners);
            synchronized (genericObjectPool) {
                Client client = (Client)clientPool.borrowObject();
                clientPool.returnObject(client);
                return client;
            }
        }
        catch (Exception e) {
            this.reconnectMgr.addReconnectTask(appName, targetUrl, localAddress, copyListeners);
            String msg = LogResources.getLog("getConnectFail", targetUrl);
            throw new RemotingException(msg, e);
        }
    }

    @Override
    public ClientManager.ClientFuture getAsync(String appName, String targetUrl, InetSocketAddress localAddress, List<IOEventListener> listeners, Map<Class<?>, RequestProcessor<?>> processors) {
        List<IOEventListener> copy = DefaultClientManager.copyListener(listeners, processors);
        String key = ClientKeyUtil.singleClientKey(appName, targetUrl, localAddress);
        return this.repoMgr.getSingleClientAsync(key, copy);
    }

    public void stopAllReconnectTasks() throws InterruptedException {
        this.reconnectMgr.stopAllTasks();
    }

    public int reconnectTasks() {
        return this.reconnectMgr.taskSize();
    }

    @Override
    public ClientConnectionFactory getConnectionFactory(String appName) {
        return this.repoMgr.getConnectionFactory(appName);
    }

    public Map<String, ClientConnectionFactory> clientFactorySnapshot() throws Exception {
        return this.repoMgr.clientFactorySnapshot();
    }

    @Override
    public void closeAllClients(String appName) {
        if (StringUtils.isBlank(appName)) {
            try {
                for (Map.Entry<String, ClientConnectionFactory> ccf : this.repoMgr.clientFactorySnapshot().entrySet()) {
                    ccf.getValue().closeAllClients();
                }
            }
            catch (Exception e) {
                LoggerInit.LOGGER.warn("\u5173\u95ed\u8fde\u63a5\u5de5\u5382\u6240\u6709\u8fde\u63a5\u65f6\u51fa\u9519", e.getCause());
            }
        } else {
            this.getConnectionFactory(appName).closeAllClients();
        }
    }

    private static List<IOEventListener> copyListener(List<IOEventListener> listeners, Map<Class<?>, RequestProcessor<?>> processors) {
        ArrayList<IOEventListener> listenersCopy = new ArrayList<IOEventListener>();
        if (null != listeners) {
            listenersCopy.addAll(listeners);
        }
        if (null != processors) {
            DefaultMsgListener msgListener = new DefaultMsgListener();
            for (RequestProcessor<?> p : processors.values()) {
                msgListener.registerProcessor(p);
            }
            listenersCopy.add(msgListener);
        }
        return listenersCopy;
    }

    static {
        timer.scheduleWithFixedDelay(new BackDoorDoggie(), 0L, 30L, TimeUnit.SECONDS);
    }
}

