/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoSession;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.WriteFuture;
import com.taobao.remoting.Client;
import com.taobao.remoting.RemotingException;
import com.taobao.remoting.RequestControl;
import com.taobao.remoting.ResponseCallback;
import com.taobao.remoting.ResponseFuture;
import com.taobao.remoting.impl.ClientKeyUtil;
import com.taobao.remoting.impl.ConnectionRequest;
import com.taobao.remoting.impl.ConnectionResponse;
import com.taobao.remoting.impl.DefaultConnection;
import com.taobao.remoting.impl.DefaultRespFuture;
import com.taobao.remoting.impl.RequestControlImpl;
import com.taobao.remoting.locale.LogResources;
import com.taobao.remoting.util.ConnectionUrl;
import com.taobao.remoting.util.LoggerInit;
import com.taobao.remoting.util.UnsafeCast;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultClient
implements Client {
    private static final String SESSION_2_CLIENT = "session2client";
    private String appName;
    private String clientKey;
    private String targetUrl;
    private IoSession session;
    private long respTimeoutMs;
    private byte serializeProtocol;
    private volatile transient Map<Long, ConnectionRequest> pendingRequests;

    DefaultClient(IoSession _session, String _clientKey) {
        this.session = _session;
        this.clientKey = _clientKey;
        this.session.setAttribute(SESSION_2_CLIENT, this);
        this.pendingRequests = new ConcurrentHashMap<Long, ConnectionRequest>();
        if (null != this.clientKey) {
            Object[] tmp = ClientKeyUtil.parseClientKey(this.clientKey);
            this.appName = (String)tmp[0];
            this.targetUrl = (String)tmp[1];
            ConnectionUrl.get(this.targetUrl);
            this.respTimeoutMs = ConnectionUrl.getReadTimeout(this.targetUrl);
            this.serializeProtocol = ConnectionUrl.getSerializeProtocol(this.targetUrl);
        }
    }

    public static final Client findBySession(IoSession session) {
        return (Client)UnsafeCast.cast(session.getAttribute(SESSION_2_CLIENT));
    }

    @Override
    public Object invokeWithSync(Object appRequest, RequestControl control) throws RemotingException, InterruptedException {
        ResponseFuture future = this.invokeWithFuture(appRequest, control);
        return future.get();
    }

    @Override
    public ResponseFuture invokeWithFuture(Object appRequest, RequestControl control) {
        return this.invokeWithFuture(appRequest, control, null);
    }

    @Override
    public void invokeWithCallback(Object appRequest, ResponseCallback callback, RequestControl control) {
        this.invokeWithFuture(appRequest, control, callback);
    }

    private ResponseFuture invokeWithFuture(Object appRequest, RequestControl control, ResponseCallback callback) {
        byte protocol = this.getProtocol(control);
        long timeout = this.getTimeout(control);
        if (timeout <= 0L) {
            throw new IllegalArgumentException("\u54cd\u5e94\u8d85\u65f6\u5e94\u8be5\u4e3a\u6b63\u503c.");
        }
        ConnectionRequest request = control == null ? new ConnectionRequest(appRequest) : new ConnectionRequest(appRequest, control.getRspClassLoader());
        DefaultRespFuture respFuture = new DefaultRespFuture(request);
        respFuture.setRespCallback(callback);
        request.setRespTimeout(timeout);
        request.setRespFuture(respFuture);
        request.setSerializeProtocol(protocol);
        this.getConnection().write(request, ((DefaultRespFuture)request.getRespFuture()).getWriteFutureListener());
        return respFuture;
    }

    @Override
    public void oneway(Object appRequest) {
        this.oneway(appRequest, null);
    }

    @Override
    public WriteFuture oneway(Object appRequest, RequestControl control) {
        ConnectionRequest request = control == null ? new ConnectionRequest(appRequest) : new ConnectionRequest(appRequest, control.getRspClassLoader());
        request.setDirection((byte)1);
        request.setSerializeProtocol(this.getProtocol(control));
        return this.getConnection().write(request, null);
    }

    @Override
    @Deprecated
    public Object invoke(Object appRequest) throws RemotingException, InterruptedException {
        return this.invokeWithSync(appRequest, null);
    }

    @Override
    @Deprecated
    public Object invoke(Object appRequest, byte protocol) throws RemotingException, InterruptedException {
        return this.invokeWithSync(appRequest, new RequestControlImpl(protocol));
    }

    @Override
    @Deprecated
    public Object invoke(Object appRequest, long timeoutMs) throws RemotingException, InterruptedException {
        return this.invokeWithSync(appRequest, new RequestControlImpl(timeoutMs));
    }

    @Override
    @Deprecated
    public void invoke(Object appRequest, ResponseCallback callback) {
        this.invokeWithCallback(appRequest, callback, null);
    }

    @Override
    @Deprecated
    public void invoke(Object appRequest, ResponseCallback callback, long timeoutMs) {
        RequestControlImpl control = new RequestControlImpl(timeoutMs);
        this.invokeWithCallback(appRequest, callback, control);
    }

    @Override
    @Deprecated
    public ResponseFuture invokeWithFuture(Object appRequest) {
        return this.invokeWithFuture(appRequest, null);
    }

    @Override
    public boolean isConnected() {
        return this.getConnection().isConnected();
    }

    @Override
    @Deprecated
    public void destroy() {
        if (this.getConnection() != null) {
            this.getConnection().close();
        }
    }

    @Override
    public void destroy(String cause) {
        if (null != this.getConnection()) {
            this.getConnection().close(cause);
        }
    }

    @Override
    public String getConnectionUrl() {
        return this.targetUrl;
    }

    public String getConnectionProperty(String property) {
        return ConnectionUrl.get(this.targetUrl).getProperty(property);
    }

    @Override
    public int getRemotePort() {
        return this.getConnection().getRemotePort();
    }

    @Override
    public DefaultConnection getConnection() {
        return DefaultConnection.findBySession(this.session);
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public String getClientKey() {
        return this.clientKey;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TCP\u5ba2\u6237\u7aef\u8fde\u63a5[");
        sb.append("ClientKey=").append(this.clientKey).append(", ");
        sb.append(this.getConnection()).append("]");
        return sb.toString();
    }

    private byte getProtocol(RequestControl control) {
        return control != null && control.isProtocolControl() ? control.getProtocol() : this.serializeProtocol;
    }

    private long getTimeout(RequestControl control) {
        return control != null && control.isTimeoutControl() ? control.getTimeout() : this.respTimeoutMs;
    }

    void addPendingRequest(ConnectionRequest connRequest) {
        this.pendingRequests.put(connRequest.getId(), connRequest);
    }

    private ConnectionRequest delPendingRequest(long requestId) {
        return this.pendingRequests.remove(requestId);
    }

    public ConnectionRequest getPendingRequest(long requestId) {
        return this.pendingRequests.get(requestId);
    }

    Map<Long, ConnectionRequest> getPendingRequests() {
        return this.pendingRequests;
    }

    @Override
    public boolean putResponse(ConnectionResponse connResp) {
        long requestId = connResp.getRequestId();
        ConnectionRequest connRequest = this.delPendingRequest(requestId);
        if (null == connRequest) {
            Object appResp = connResp.getAppResponse();
            String appRespClazz = null == appResp ? "null" : appResp.getClass().getName();
            String msg = LogResources.getLog("noResponseReceiver", requestId, connResp.getHost(), appRespClazz);
            LoggerInit.LOGGER.error(msg);
            return false;
        }
        DefaultRespFuture respFuture = (DefaultRespFuture)connRequest.getRespFuture();
        respFuture.setResponse(connResp);
        return true;
    }
}

