/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl;

import com.taobao.remoting.Client;
import com.taobao.remoting.ResponseFuture;
import com.taobao.remoting.impl.RemotingMessage;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

public class ConnectionRequest
implements RemotingMessage {
    private static final long serialVersionUID = 1L;
    private RequestContext ctx = new RequestContext();
    private transient Object appRequest;
    private transient Client client;
    private transient long respTimeout;
    private transient ResponseFuture respFuture;
    private final transient ClassLoader loader;

    private ConnectionRequest() {
        this.loader = null;
    }

    public ConnectionRequest(Object _appRequest) {
        this(_appRequest, null);
    }

    public ConnectionRequest(Object _appRequest, ClassLoader responseLoader) {
        this.appRequest = _appRequest;
        this.ctx.id = IDGenerator.getNextId();
        this.loader = responseLoader;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public Object getAppRequest() {
        return this.appRequest;
    }

    public void setAppRequest(Object _appRequest) {
        this.appRequest = _appRequest;
    }

    public long getId() {
        return this.ctx.id;
    }

    @Override
    public long getMessageId() {
        return this.ctx.id;
    }

    @Override
    public byte getSerializeProtocol() {
        return this.ctx.serializeProtocol;
    }

    public void setSerializeProtocol(byte serializeType) {
        this.ctx.serializeProtocol = serializeType;
    }

    public byte getDirection() {
        return this.ctx.direction;
    }

    public void setDirection(byte direction) {
        this.ctx.direction = direction;
    }

    public long getRespTimeout() {
        return this.respTimeout;
    }

    public void setRespTimeout(long respTimeout) {
        this.respTimeout = respTimeout;
    }

    public ResponseFuture getRespFuture() {
        return this.respFuture;
    }

    public void setRespFuture(ResponseFuture respFuture) {
        this.respFuture = respFuture;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Client getClient() {
        return this.client;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionRequest[");
        sb.append("requestId=").append(this.ctx.id);
        sb.append(", protocol=").append(this.ctx.serializeProtocol);
        sb.append(", direction=").append(this.ctx.direction);
        sb.append(", appRequest=").append(this.appRequest);
        sb.append("]");
        return sb.toString();
    }

    public static class IDGenerator {
        private static AtomicLong id = new AtomicLong(0L);

        public static long getNextId() {
            if (id.longValue() > 9223372036854774807L) {
                id.getAndSet(0L);
            }
            return id.incrementAndGet();
        }
    }

    private class RequestContext
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private long id;
        private transient byte serializeProtocol = 1;
        private transient byte direction = (byte)2;

        private RequestContext() {
        }
    }
}

