/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl;

import java.net.InetSocketAddress;

public class ClientKeyUtil {
    private static final char SPLIT = '#';

    static String singleClientKey(String appName, String url) {
        return ClientKeyUtil.singleClientKey(appName, url, null);
    }

    static String singleClientKey(String appName, String url, InetSocketAddress localAddress) {
        if (null == localAddress) {
            return ClientKeyUtil.escape(appName) + '#' + ClientKeyUtil.escape(url);
        }
        return ClientKeyUtil.escape(appName) + '#' + ClientKeyUtil.escape(url) + '#' + localAddress.getAddress().getHostAddress() + '#' + localAddress.getPort();
    }

    static Object[] parseClientKey(String clientKey) {
        String[] tmp = clientKey.split("#");
        Object[] result = new Object[]{ClientKeyUtil.unescape(tmp[0]), ClientKeyUtil.unescape(tmp[1]), tmp.length > 2 ? new InetSocketAddress(tmp[2], Integer.parseInt(tmp[3])) : null};
        return result;
    }

    static String targetUrl(String clientKey) {
        return (String)ClientKeyUtil.parseClientKey(clientKey)[1];
    }

    private static String escape(String str) {
        return str.replace('#', '\u00a3');
    }

    private static String unescape(String str) {
        return str.replace('\u00a3', '#');
    }
}

