/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.remoting.impl;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.ConnectFuture;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.RuntimeIOException;
import com.taobao.remoting.Client;
import com.taobao.remoting.ClientManager;
import com.taobao.remoting.ConnectCancelledException;
import com.taobao.remoting.RemotingException;
import com.taobao.remoting.impl.DefaultClient;
import com.taobao.remoting.locale.LogResources;

class ClientFutureImpl
implements ClientManager.ClientFuture {
    private final String url;
    private final ConnectFuture minaFuture;

    ClientFutureImpl(String _url, ConnectFuture _f) {
        this.url = _url;
        this.minaFuture = _f;
    }

    @Override
    public String targetUrl() {
        return this.url;
    }

    @Override
    public boolean cancel() {
        String log = LogResources.getLog("connectCancelled", this.url);
        ConnectCancelledException ex = new ConnectCancelledException(log);
        return this.minaFuture.setException(ex, null);
    }

    @Override
    public boolean isDone() {
        return this.minaFuture.isReady();
    }

    @Override
    public boolean isConnected() {
        if (!this.isDone()) {
            return false;
        }
        try {
            this.minaFuture.getSession();
            return true;
        }
        catch (RuntimeIOException ioe) {
            return false;
        }
    }

    @Override
    public boolean isCancelled() {
        if (!this.isDone()) {
            return false;
        }
        try {
            this.minaFuture.getSession();
            return false;
        }
        catch (RuntimeIOException ioe) {
            return null != ioe.getCause() && ioe.getCause().getClass() == ConnectCancelledException.class;
        }
    }

    @Override
    public Client get(long timeoutMs) throws RemotingException {
        if (timeoutMs < 0L) {
            this.minaFuture.join();
        } else if (timeoutMs > 0L) {
            this.minaFuture.join(timeoutMs);
        }
        if (!this.isDone()) {
            return null;
        }
        try {
            return DefaultClient.findBySession(this.minaFuture.getSession());
        }
        catch (RuntimeIOException e) {
            Throwable cause = e.getCause();
            if (null != cause && cause.getClass() == ConnectCancelledException.class) {
                throw (ConnectCancelledException)cause;
            }
            String log = LogResources.getLog("connectFail", this.url);
            throw new RemotingException(log, e.getCause());
        }
    }
}

