/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.common.task;

import com.taobao.config.common.task.AncientSinewWrappedLamina;
import com.taobao.config.common.task.Bow;
import com.taobao.config.common.task.Eaglehorn;
import com.taobao.config.common.task.LightQuiver;
import com.taobao.config.common.task.MagicArrow;
import com.taobao.config.common.task.NormalArrow;
import com.taobao.config.common.task.Quiver;
import com.taobao.config.common.task.SmugglersAmmoPouch;
import com.taobao.config.common.task.WindForce;
import java.util.Date;

public class TaskManager {
    public final int FEATURE_PRIORITIZED = 1;
    public final int FEATURE_DELAYABLE = 2;
    public final int FEATURE_CLASSIFIED = 4;
    public final int FEATURE_MULTITHREADED = 8;
    final Quiver quiver;
    final Bow bow;

    public TaskManager() {
        this(65535);
    }

    public TaskManager(int features) {
        this.quiver = (features & 2 & 1) > 0 ? new SmugglersAmmoPouch(new AncientSinewWrappedLamina()) : ((features & 1) > 0 ? new AncientSinewWrappedLamina() : new LightQuiver());
        this.bow = (features & 8) > 0 ? new WindForce() : new Eaglehorn();
    }

    public void add(Runnable task) {
        this.quiver.load(new NormalArrow(task));
    }

    public void schedule(Runnable task, Date time) {
        this.quiver.load(new MagicArrow(task, time));
    }

    public void start() throws InterruptedException {
        while (true) {
            this.bow.nock(this.quiver.pick());
        }
    }
}

