/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.common.protocol.utils;

import com.alibaba.cs.shaded.com.alibaba.cs.shaded.com.alibaba.configserver.google.gson.Gson;
import com.alibaba.cs.shaded.com.alibaba.cs.shaded.com.alibaba.configserver.google.gson.GsonBuilder;
import com.alibaba.cs.shaded.com.alibaba.cs.shaded.com.alibaba.configserver.google.gson.internal.StringMap;
import com.alibaba.cs.shaded.com.alibaba.cs.shaded.com.alibaba.configserver.google.gson.reflect.TypeToken;
import com.alibaba.cs.shaded.com.alibaba.cs.shaded.com.taobao.middleware.logger.Logger;
import com.alibaba.cs.shaded.com.alibaba.cs.shaded.com.taobao.middleware.logger.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class TransmitUtils {
    private static Logger LOG = LoggerFactory.getLogger(TransmitUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gzip(byte[] rawBytes) throws IOException {
        if (rawBytes == null) {
            throw new IllegalArgumentException("zip param is null");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (GZIPOutputStream gzout = new GZIPOutputStream(bout);){
            gzout.write(rawBytes);
            gzout.finish();
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] unzip(byte[] zipBytes) throws IOException {
        if (zipBytes == null) {
            throw new IllegalArgumentException("unzip param is null");
        }
        GZIPInputStream gzin = new GZIPInputStream(new ByteArrayInputStream(zipBytes));
        byte[] tmp = new byte[512];
        int count = 0;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            while ((count = gzin.read(tmp)) >= 0) {
                bout.write(tmp, 0, count);
            }
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        finally {
            gzin.close();
        }
    }

    public static String toJSON(List<?> datas) {
        if (datas == null || datas.isEmpty()) {
            return "";
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson(datas);
    }

    public static String toJsonFromMap(Map<?, ?> datas) {
        if (datas == null || datas.isEmpty()) {
            return "";
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson(datas);
    }

    public static List<Object> fromJSON(String jsonText) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        List list = (List)gson.fromJson(jsonText, new TypeToken<Object>(){}.getType());
        return TransmitUtils.toConfigServerDataType(list);
    }

    private static List<Object> toConfigServerDataType(List<Object> resultList) {
        ArrayList<Object> convertedList = new ArrayList<Object>();
        for (Object object : resultList) {
            if (object instanceof StringMap) {
                convertedList.add(TransmitUtils.convertStringMap2Properties((StringMap)object));
                continue;
            }
            if (object instanceof String) {
                convertedList.add(object);
                continue;
            }
            LOG.warn("json value is neither String nor Properties, will be ignored");
        }
        return convertedList;
    }

    private static Properties convertStringMap2Properties(StringMap<Object> strMap) {
        Properties properties = new Properties();
        for (Map.Entry<String, Object> entry : strMap.entrySet()) {
            if (entry.getValue() instanceof String) {
                properties.put(entry.getKey(), entry.getValue());
                continue;
            }
            LOG.warn("non-string value in StringMap. " + entry.getValue().getClass() + ", " + entry.getValue());
        }
        return properties;
    }

    public static void main(String[] args) throws IOException {
        String ptn = "{0}:8080?sofa.service.binding.ws.core.port=8080&app_name=cif&sofa.service.interface.mode=spring&_TIMEOUT=3000";
        int count = 1000;
        ArrayList<String> list = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            list.add(MessageFormat.format(ptn, new Random().nextInt()));
        }
        String jsonStr = TransmitUtils.toJSON(list);
        System.out.println(jsonStr);
        byte[] gzipBytes = TransmitUtils.gzip(jsonStr.getBytes());
        System.out.println(jsonStr.getBytes().length + " -> " + gzipBytes.length);
        byte[] unzipBytes = TransmitUtils.unzip(gzipBytes);
        String unzipStr = new String(unzipBytes);
        System.out.println(jsonStr.equals(unzipStr));
    }
}

