/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.common.protocol;

import com.alibaba.cs.shaded.com.alibaba.cs.shaded.com.taobao.middleware.logger.Logger;
import com.alibaba.cs.shaded.com.alibaba.cs.shaded.com.taobao.middleware.logger.LoggerFactory;
import com.taobao.config.common.Revision;
import com.taobao.config.common.protocol.ProtocolElement;
import com.taobao.config.common.protocol.ProtocolElementUid;
import com.taobao.config.common.protocol.Swizzle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserDataGroupElement
implements ProtocolElement {
    public String dataId;
    public Revision revision;
    public String[] clientIds;
    private Map<String, List<Swizzle>> ipGroupDataMap = new HashMap<String, List<Swizzle>>();
    private Map<String, Boolean> ipGroupisGzipMap = new HashMap<String, Boolean>();
    private Map<String, List<Map<String, Integer>>> ipGroupBaseDataMap = new HashMap<String, List<Map<String, Integer>>>();
    private Map<String, List<String>> strBufferPoolMap = new HashMap<String, List<String>>();
    public boolean needAck = true;
    private int initSize = 0;
    public Map<String, Integer> ipGroupDataSize = new HashMap<String, Integer>();
    static final Logger log = LoggerFactory.getLogger(UserDataGroupElement.class);
    private static final long serialVersionUID = 1L;

    public UserDataGroupElement(String dataId, Revision rev) {
        if (dataId == null) {
            throw new IllegalArgumentException("dataId can't be null");
        }
        this.dataId = dataId;
        this.revision = rev == null ? Revision.UNINITIALIZED_REVISION : rev;
    }

    public Revision getRevision() {
        return this.revision;
    }

    public boolean addDatum(List<Swizzle> data, Object datum) {
        return datum instanceof Swizzle ? data.add((Swizzle)datum) : data.add(new Swizzle(datum));
    }

    public void setDataMap(Map<String, List<Swizzle>> dataMap) {
        for (Map.Entry<String, List<Swizzle>> data : dataMap.entrySet()) {
            String key = data.getKey();
            List<Swizzle> value = data.getValue();
            if (value != null) {
                this.initSize += value.size();
            } else {
                log.info("[data] ipGroup[" + key + "] is null in ipGroupDataMap");
            }
            this.ipGroupDataMap = dataMap;
        }
    }

    public void setBaseDataMap(Map<String, List<Map<String, Integer>>> baseDataMap) {
        this.ipGroupBaseDataMap = baseDataMap;
    }

    public void setisGzipMap(Map<String, Boolean> isGzipMap) {
        this.ipGroupisGzipMap = isGzipMap;
    }

    public Map<String, List<Swizzle>> getIpGroupDataMap() {
        return this.ipGroupDataMap;
    }

    public Map<String, Boolean> getIpGroupisGzipMap() {
        return this.ipGroupisGzipMap;
    }

    public Map<String, List<Map<String, Integer>>> getIpGroupBaseDataMap() {
        return this.ipGroupBaseDataMap;
    }

    public boolean addDatum(String ipGroup, Object datum) {
        List<Swizzle> data = this.ipGroupDataMap.get(ipGroup);
        return datum instanceof Swizzle ? data.add((Swizzle)datum) : data.add(new Swizzle(datum));
    }

    public void addData(String ipGroup, List<?> data) {
        for (Object datum : data) {
            this.addDatum(ipGroup, datum);
        }
    }

    public List<Map<String, String>> getIpGroupBaseData(String ipGroup) {
        List<Map<String, Integer>> baseDatas = this.ipGroupBaseDataMap.get(ipGroup);
        List<String> strBufferPool = this.strBufferPoolMap.get(ipGroup);
        ArrayList<Map<String, String>> resultBaseDatas = new ArrayList<Map<String, String>>();
        if (strBufferPool == null) {
            log.error("%s", "metaData Restore algorithm strBufferPool==null, dataid=" + this.dataId + ", ipGroup=" + ipGroup);
        } else if (baseDatas == null) {
            log.error("%s", "metaData Restore algorithm baseDatas==null, dataid=" + this.dataId + ", ipGroup=" + ipGroup);
        } else {
            for (Map<String, Integer> baseData : baseDatas) {
                HashMap<String, String> data = new HashMap<String, String>();
                for (Map.Entry<String, Integer> entry : baseData.entrySet()) {
                    Integer index = entry.getValue();
                    if (index == null) continue;
                    if (index < strBufferPool.size()) {
                        String trueValue = strBufferPool.get(index);
                        data.put(entry.getKey(), trueValue);
                        continue;
                    }
                    log.error("%s", "metaData Restore algorithm, metaData key=" + entry.getKey() + " index(" + index + ") > strBufferPool.size(" + strBufferPool.size() + ") set null return data, dataid=" + this.dataId + ", ipGroup=" + ipGroup);
                    data.put(entry.getKey(), null);
                }
                resultBaseDatas.add(data);
            }
        }
        return resultBaseDatas;
    }

    public String getDataId() {
        return this.dataId;
    }

    public int size() {
        return this.initSize;
    }

    public Map<String, List<String>> getStrBufferPoolMap() {
        return this.strBufferPoolMap;
    }

    public void setStrBufferPoolMap(Map<String, List<String>> strBufferPoolMap) {
        this.strBufferPoolMap = strBufferPoolMap;
    }

    public List<Object> getShelteredData(List<Swizzle> data) {
        if (data != null) {
            return new ArrayList<Object>(data);
        }
        return new ArrayList<Object>();
    }

    public Map<String, List<Object>> getActualData() {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        for (Map.Entry<String, List<Swizzle>> entry : this.ipGroupDataMap.entrySet()) {
            List<Object> data = this.getShelteredData(entry.getValue());
            List<Map<String, Integer>> baseDataMap = this.ipGroupBaseDataMap.get(entry.getKey());
            UserDataGroupElement.extractShelteredData(data, baseDataMap);
            map.put(entry.getKey(), data);
        }
        return map;
    }

    public static void extractShelteredData(List<Object> data, List<Map<String, Integer>> baseDataMap) {
        for (int i = 0; i < data.size(); ++i) {
            Object datum = data.get(i);
            if (!(datum instanceof Swizzle)) continue;
            try {
                datum = ((Swizzle)datum).extract();
                if (datum == null) {
                    log.info("[Data] Null datum is removed.");
                }
            }
            catch (Exception e) {
                log.warn("[Data] Failed to deserialize the datum due to " + e);
            }
            if (datum != null) {
                data.set(i, datum);
                continue;
            }
            data.remove(i);
            baseDataMap.remove(i);
            --i;
        }
    }

    public boolean needAck() {
        return this.needAck;
    }

    public void setNeedAck(boolean needAck) {
        this.needAck = needAck;
    }

    @Override
    public ProtocolElementUid uid() {
        return ProtocolElementUid.ELEMENT_USER_GROUP_DATA;
    }
}

