/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.common.protocol;

import com.alibaba.cs.shaded.com.alibaba.cs.shaded.com.taobao.middleware.logger.Logger;
import com.alibaba.cs.shaded.com.alibaba.cs.shaded.com.taobao.middleware.logger.LoggerFactory;
import com.taobao.config.common.Revision;
import com.taobao.config.common.protocol.ProtocolElement;
import com.taobao.config.common.protocol.ProtocolElementUid;
import com.taobao.config.common.protocol.Swizzle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class UserDataElement
implements ProtocolElement {
    public String dataId;
    public Revision revision;
    public String[] clientIds;
    private List<Swizzle> data = new LinkedList<Swizzle>();
    private Map<String, List<Swizzle>> subIpGroupDataMap = new HashMap<String, List<Swizzle>>();
    private Map<String, List<Swizzle>> subIpGroupSMap = new HashMap<String, List<Swizzle>>();
    public boolean needAck = true;
    static final Logger log = LoggerFactory.getLogger(UserDataElement.class);
    private static final long serialVersionUID = 1L;

    public UserDataElement(String dataId, Revision rev) {
        if (dataId == null) {
            throw new IllegalArgumentException("dataId can't be null");
        }
        this.dataId = dataId;
        this.revision = rev == null ? Revision.UNINITIALIZED_REVISION : rev;
    }

    public Revision getRevision() {
        return this.revision;
    }

    public boolean addDatum(Object datum) {
        return datum instanceof Swizzle ? this.data.add((Swizzle)datum) : this.data.add(new Swizzle(datum));
    }

    public void addData(List<?> data) {
        for (Object datum : data) {
            this.addDatum(datum);
        }
    }

    public String getDataId() {
        return this.dataId;
    }

    public int size() {
        return this.data.size();
    }

    public List<Object> getShelteredData() {
        return new ArrayList<Object>(this.data);
    }

    public List<Object> getActualData() {
        List<Object> data = this.getShelteredData();
        UserDataElement.extractShelteredData(data);
        return data;
    }

    public static void extractShelteredData(List<Object> data) {
        for (int i = 0; i < data.size(); ++i) {
            Object datum = data.get(i);
            if (!(datum instanceof Swizzle)) continue;
            try {
                datum = ((Swizzle)datum).extract();
                if (datum == null) {
                    log.info("[Data] Null datum is removed.");
                }
            }
            catch (Exception e) {
                log.warn("[Data] Failed to deserialize the datum due to " + e);
            }
            if (datum != null) {
                data.set(i, datum);
                continue;
            }
            data.remove(i);
            --i;
        }
    }

    public boolean needAck() {
        return this.needAck;
    }

    public void setNeedAck(boolean needAck) {
        this.needAck = needAck;
    }

    @Override
    public ProtocolElementUid uid() {
        return ProtocolElementUid.ELEMENT_USER_DATA;
    }
}

