/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.common.protocol;

import com.taobao.config.common.protocol.InvalidElement;
import com.taobao.config.common.protocol.ProtocolElement;
import com.taobao.config.common.protocol.ProtocolElementUid;
import com.taobao.config.common.protocol.ProtocolElementUidUnmatchedException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

abstract class ProtocolPacket
implements ProtocolElement,
Serializable,
Iterable<ProtocolElement> {
    private transient List<ProtocolElement> elements = new ArrayList<ProtocolElement>();
    private static final long serialVersionUID = -3491248796286893704L;

    ProtocolPacket() {
    }

    protected void addElement(ProtocolElement element) {
        if (null == element) {
            new Exception("Add null element.").printStackTrace();
        }
        this.elements.add(element);
    }

    protected boolean setElement(ProtocolElement element) {
        for (int index = 0; index < this.elements.size(); ++index) {
            if (this.elements.get(index).uid() != element.uid()) continue;
            this.elements.set(index, element);
            return false;
        }
        this.elements.add(element);
        return true;
    }

    protected boolean removeElement(ProtocolElement element) {
        for (int index = 0; index < this.elements.size(); ++index) {
            if (this.elements.get(index) != element) continue;
            this.elements.remove(index);
            return true;
        }
        return false;
    }

    protected ProtocolElement getElement(ProtocolElementUid uid) {
        for (ProtocolElement element : this.elements) {
            if (element.uid() != uid) continue;
            return element;
        }
        return null;
    }

    protected List<ProtocolElement> getAll() {
        return this.elements;
    }

    protected void reset() {
        this.elements.clear();
    }

    public int countElements() {
        return this.elements.size();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int count = in.readInt();
        this.elements = new ArrayList<ProtocolElement>(count);
        for (int i = 0; i < count; ++i) {
            ProtocolElement element;
            int uid = in.readInt();
            try {
                Object object = in.readObject();
                element = (ProtocolElement)object;
                if (uid != element.uid().toInt()) {
                    element = new InvalidElement(uid, new ProtocolElementUidUnmatchedException(element, uid));
                }
            }
            catch (Exception e) {
                element = new InvalidElement(uid, e);
            }
            this.elements.add(element);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.elements.size());
        for (ProtocolElement element : this.elements) {
            out.writeInt(element.uid().toInt());
            out.writeObject(element);
        }
    }

    @Override
    public Iterator<ProtocolElement> iterator() {
        return this.elements.iterator();
    }
}

