/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.common;

import com.taobao.config.common.RemotingURLHandler;
import com.taobao.config.common.utils.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;

public class ConfigServerURL {
    public static final String KEY_PRIORITY = "priority";
    static Properties defaults = new Properties();
    private static final String DEFAULT_PROTOCOL = "remoting";
    private final URL url;
    private transient Properties properties;
    private transient boolean needQueryUpdate = false;
    private static final RemotingURLHandler handler;

    public ConfigServerURL(String url) throws MalformedURLException {
        if (!url.contains("://")) {
            url = "remoting://" + url;
        }
        this.url = new URL(null, url, handler);
    }

    public ConfigServerURL(String host, int port) throws MalformedURLException {
        this(DEFAULT_PROTOCOL, host, port);
    }

    public ConfigServerURL(String protocol, String host, int port) throws MalformedURLException {
        this.url = new URL(protocol, host, port, "", handler);
    }

    public void setProperty(String key, String value) {
        this.ensureQueryLoaded();
        this.properties.setProperty(key, value == null ? "" : value);
        this.needQueryUpdate = true;
    }

    public String getProperty(String key) {
        this.ensureQueryLoaded();
        return this.properties.getProperty(key);
    }

    public String getHost() {
        return this.url.getHost();
    }

    public int getPort() {
        int port = this.url.getPort();
        String portStr = System.getProperty("configserver.port");
        if (!StringUtils.isBlank(portStr)) {
            port = Integer.parseInt(portStr);
        }
        return port > 0 ? port : this.url.getDefaultPort();
    }

    public String getServerId() {
        return this.getHost() + ":" + this.getPort();
    }

    public String toString() {
        if (this.needQueryUpdate) {
            this.updateQuery();
        }
        return this.url.toString();
    }

    private void updateQuery() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<Object, Object> property : this.properties.entrySet()) {
            if (!isFirst) {
                sb.append('&');
            } else {
                isFirst = false;
            }
            sb.append(property.getKey() + "=" + property.getValue());
        }
        handler.setQuery(this.url, sb.toString());
        this.needQueryUpdate = false;
    }

    private void ensureQueryLoaded() {
        if (this.properties != null) {
            return;
        }
        this.properties = new Properties(defaults);
        String query = this.url.getQuery();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                String[] tokens = pair.split("=", 2);
                if (tokens[0].length() == 0) continue;
                this.properties.setProperty(tokens[0], tokens.length > 1 ? tokens[1] : "");
            }
        }
    }

    static {
        defaults.setProperty(KEY_PRIORITY, "0");
        handler = new RemotingURLHandler();
    }
}

