/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client.processor;

import com.taobao.config.client.CachePersist;
import com.taobao.config.client.ConfigClientSetting;
import com.taobao.config.client.DefaultSubscriber;
import com.taobao.config.client.SubscriberRegistrar;
import com.taobao.config.client.bean.ObserverData;
import com.taobao.config.client.exception.ExcEvent;
import com.taobao.config.client.exception.ExcEventDispatch;
import com.taobao.config.client.exception.ExcType;
import com.taobao.config.client.processor.ProtocolElementProcessor;
import com.taobao.config.client.utils.ObserverDataUtils;
import com.taobao.config.client.utils.ZipUtil;
import com.taobao.config.common.Revision;
import com.taobao.config.common.protocol.AttributeElement;
import com.taobao.config.common.protocol.ProtocolElement;
import com.taobao.config.common.protocol.ProtocolPackage;
import com.taobao.config.common.protocol.UserDataGroupElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserDataGroupElementProcessor
extends ProtocolElementProcessor {
    private static final int DATUM_LOG_TRUNCATION_SIZE = 256;

    @Override
    void process(ProtocolElement input, ProtocolPackage pp) {
        UserDataGroupElement dataGroupElement = (UserDataGroupElement)input;
        String dataId = dataGroupElement.dataId;
        Revision revision = dataGroupElement.revision;
        String[] clientIds = this.processClientId(dataGroupElement.clientIds, dataId);
        Map<String, List<ObserverData>> dataGroup = null;
        try {
            dataGroup = this.getDataList(dataId, revision, dataGroupElement);
        }
        catch (IOException e) {
            log.error("%s", "[GroupData-received] but zip format error, dataId=" + dataGroupElement.dataId + ", clientIds=" + dataGroupElement.clientIds);
            return;
        }
        if (revision == null || dataId == null || dataGroup == null) {
            log.error("%s", "[Protocol] Protocol error in parsing UserDataGroupElement!");
            return;
        }
        List<DefaultSubscriber> subscribers = this.getSubscribers(clientIds, dataId);
        boolean isSpasAccesss = this.checkProtocolElement(pp);
        for (DefaultSubscriber subscriber : subscribers) {
            if (!ConfigClientSetting.isNotCachePersist() && !ConfigClientSetting.isTimerCachePersist()) {
                CachePersist.save(dataId, subscriber.getRegistration().getGroup(), subscriber.getRegistration().getTenant(), dataGroup, subscriber.getServerListManager().getEnv());
            }
            if (!isSpasAccesss) {
                String errorMessage = "[GroupData-received] spas-authentication-failed! dataId:" + dataId + " revision:" + revision;
                log.error("%s", errorMessage);
                ExcEventDispatch.fireEvent(new ExcEvent(subscriber.getRegistration().getDataId(), subscriber.getRegistration().getGroup(), subscriber.getRegistration().getTenant(), ExcType.SUB_PERMISSION, errorMessage));
                continue;
            }
            subscriber.update(revision, null, dataGroup);
        }
    }

    private boolean checkProtocolElement(ProtocolPackage pp) {
        boolean isSpasAccesss = true;
        for (ProtocolElement elementItem : pp) {
            AttributeElement attriItem;
            if (!(elementItem instanceof AttributeElement) || !(attriItem = (AttributeElement)elementItem).getName().equals("!SpasAccessKey")) continue;
            isSpasAccesss = false;
        }
        return isSpasAccesss;
    }

    private List<DefaultSubscriber> getSubscribers(String[] clientIds, String dataId) {
        ArrayList<DefaultSubscriber> subscribers = new ArrayList<DefaultSubscriber>();
        for (String clientId : clientIds) {
            if (clientId == null || clientId.length() <= 0) {
                log.error("%s", "[Protocol] Null or empty client ID in UserDataGroupElement.");
                continue;
            }
            DefaultSubscriber subscriber = null;
            for (int failCount = 0; null == subscriber && failCount < 3; ++failCount) {
                subscriber = SubscriberRegistrar.find(clientId);
                if (null != subscriber) continue;
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (Exception e) {
                    log.error("%s", e.toString(), e);
                }
            }
            if (null == subscriber) {
                log.warn("########## [GroupData-subscriber-not-found] (DataID: " + dataId + ", ClientID:" + clientId + ")");
                continue;
            }
            subscribers.add(subscriber);
        }
        return subscribers;
    }

    private String[] processClientId(String[] clientIds, String dataId) {
        if (clientIds != null && clientIds.length == 0) {
            log.error("%s", "[Protocol] Empty client ID list in UserDataElement, try searching clients locally.");
            clientIds = null;
        }
        if (clientIds == null) {
            List<DefaultSubscriber> subscribers = SubscriberRegistrar.findByDataId(dataId);
            clientIds = new String[subscribers.size()];
            int i = 0;
            for (DefaultSubscriber subscriber : subscribers) {
                clientIds[i++] = subscriber.getClientId();
            }
        }
        return clientIds;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, List<ObserverData>> getDataList(String dataId, Revision revision, UserDataGroupElement userDataGroupElement) throws IOException {
        Map<String, List<Object>> ipGroupDataMap = userDataGroupElement.getActualData();
        Map<String, Boolean> ipGroupIsGzip = userDataGroupElement.getIpGroupisGzipMap();
        Map<String, Integer> ipGroupDataSizeMap = userDataGroupElement.ipGroupDataSize;
        int reportedDataSize = 0;
        int dataSize = 0;
        HashMap<String, void> allData = new HashMap<String, void>();
        for (Map.Entry<String, List<Object>> entry : ipGroupDataMap.entrySet()) {
            Integer reDataSize;
            void var12_16;
            Object var12_17 = null;
            String string = entry.getKey();
            List<Object> ipGroupData = entry.getValue();
            Boolean isGzip = ipGroupIsGzip.get(string);
            if (isGzip != null && isGzip.booleanValue()) {
                List<Object> list = ZipUtil.getPushDataFromZipContent(ipGroupData);
            } else {
                List<Object> list = ipGroupData;
            }
            if (var12_16 != null) {
                dataSize += var12_16.size();
            }
            if (ipGroupDataSizeMap != null && (reDataSize = ipGroupDataSizeMap.get(string)) != null) {
                reportedDataSize += reDataSize.intValue();
            }
            allData.put(string, var12_16);
        }
        HashMap<String, List<ObserverData>> resultData = new HashMap<String, List<ObserverData>>();
        for (Map.Entry entry : allData.entrySet()) {
            String string = (String)entry.getKey();
            List datas = (List)entry.getValue();
            List<Map<String, String>> metaData = userDataGroupElement.getIpGroupBaseData(string);
            List<Object> observerDataList = new ArrayList();
            if (datas != null && metaData != null) {
                if (datas.size() != metaData.size()) {
                    log.info("UserDataGroupElementProcessor datas.size(" + datas.size() + ") != metaData.size(" + metaData.size() + "),dataId=" + dataId + ", ipgroup=" + string);
                }
                observerDataList = ObserverDataUtils.getObserverData(datas, metaData);
            }
            resultData.put(string, observerDataList);
        }
        if (resultData == null || dataSize < 1) {
            log.info("[Data-received] (ID: " + dataId + ", Revision: " + revision + ", Empty)");
        } else {
            void var11_15;
            Object object;
            if (dataSize != reportedDataSize) {
                log.info("[Internal] Some unrecognized or corrupted data may be dropped. (Reported: " + reportedDataSize + ", Actual: " + dataSize + "). ipGroupIsGzip=" + ipGroupIsGzip);
            }
            Object var11_13 = null;
            for (Map.Entry entry : resultData.entrySet()) {
                List observerDataList = (List)entry.getValue();
                if (observerDataList == null || observerDataList.size() <= 0) continue;
                ObserverData observerData = (ObserverData)observerDataList.get(0);
                break;
            }
            Object object2 = object = var11_15 != null ? var11_15.getData() : null;
            if (object instanceof String) {
                void var13_31;
                String string = (String)object;
                if (string.length() > 256) {
                    String string2 = string.substring(0, 256) + " ...";
                }
                log.info("[Data-received] (ID: " + dataId + ", Revision: " + revision + ", Count: " + resultData.size() + ", ipGroupIsGzip=" + ipGroupIsGzip + ", String[0]: " + (String)var13_31 + ")");
            } else {
                log.info("[Data-received] (ID: " + dataId + ", Revision: " + revision + ", Count: " + resultData.size() + ", Class[0]: " + object.getClass().getSimpleName() + ")");
            }
        }
        return resultData;
    }
}

