/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client.processor;

import com.taobao.config.client.CachePersist;
import com.taobao.config.client.DefaultSubscriber;
import com.taobao.config.client.SubscriberRegistrar;
import com.taobao.config.client.exception.ExcEvent;
import com.taobao.config.client.exception.ExcEventDispatch;
import com.taobao.config.client.exception.ExcType;
import com.taobao.config.client.processor.ProtocolElementProcessor;
import com.taobao.config.client.utils.ZipUtil;
import com.taobao.config.common.Revision;
import com.taobao.config.common.protocol.AttributeElement;
import com.taobao.config.common.protocol.ProtocolElement;
import com.taobao.config.common.protocol.ProtocolPackage;
import com.taobao.config.common.protocol.UserDataElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class UserDataElementProcessor
extends ProtocolElementProcessor {
    private static final int DATUM_LOG_TRUNCATION_SIZE = 256;

    @Override
    void process(ProtocolElement input, ProtocolPackage pp) {
        UserDataElement element = (UserDataElement)input;
        String dataId = element.dataId;
        Revision revision = element.revision;
        String[] clientIds = this.processClientId(element.clientIds, dataId);
        boolean isGzip = ZipUtil.isZipContent(pp);
        List<Object> data = null;
        try {
            data = this.getDataList(isGzip, dataId, revision, element);
        }
        catch (IOException e) {
            log.error("%s", "[Data-received] but zip format error, dataId=" + element.dataId + ", clientIds=" + element.clientIds);
            return;
        }
        if (revision == null || dataId == null || data == null) {
            log.error("%s", "[Protocol] Protocol error in parsing UserDataElement!");
            return;
        }
        List<DefaultSubscriber> subscribers = this.getSubscribers(clientIds, dataId);
        boolean isSpasAccesss = this.checkProtocolElement(pp);
        for (DefaultSubscriber subscriber : subscribers) {
            CachePersist.save(dataId, subscriber.getRegistration().getGroup(), subscriber.getRegistration().getTenant(), data, subscriber.getServerListManager().getEnv());
            if (!isSpasAccesss) {
                String errorMessage = "[Data-received] spas-authentication-failed! dataId:" + dataId + " revision:" + revision;
                log.error("%s", errorMessage);
                ExcEventDispatch.fireEvent(new ExcEvent(subscriber.getRegistration().getDataId(), subscriber.getRegistration().getGroup(), subscriber.getRegistration().getTenant(), ExcType.SUB_PERMISSION, errorMessage));
                continue;
            }
            subscriber.update(revision, data, null);
        }
    }

    private boolean checkProtocolElement(ProtocolPackage pp) {
        boolean isSpasAccesss = true;
        for (ProtocolElement elementItem : pp) {
            AttributeElement attriItem;
            if (!(elementItem instanceof AttributeElement) || !(attriItem = (AttributeElement)elementItem).getName().equals("!SpasAccessKey")) continue;
            isSpasAccesss = false;
        }
        return isSpasAccesss;
    }

    private List<DefaultSubscriber> getSubscribers(String[] clientIds, String dataId) {
        ArrayList<DefaultSubscriber> subscribers = new ArrayList<DefaultSubscriber>();
        for (String clientId : clientIds) {
            if (clientId == null || clientId.length() <= 0) {
                log.error("%s", "[Protocol] Null or empty client ID in UserDataElement.");
                continue;
            }
            DefaultSubscriber subscriber = null;
            for (int failCount = 0; null == subscriber && failCount < 3; ++failCount) {
                subscriber = SubscriberRegistrar.find(clientId);
                if (null != subscriber) continue;
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (Exception e) {
                    log.error("%s", e.toString(), e);
                }
            }
            if (null == subscriber) {
                log.warn("########## [subscriber-not-found] (DataID: " + dataId + ", ClientID:" + clientId + ")");
                continue;
            }
            subscribers.add(subscriber);
        }
        return subscribers;
    }

    private String[] processClientId(String[] clientIds, String dataId) {
        if (clientIds != null && clientIds.length == 0) {
            log.error("%s", "[Protocol] Empty client ID list in UserDataElement, try searching clients locally.");
            clientIds = null;
        }
        if (clientIds == null) {
            List<DefaultSubscriber> subscribers = SubscriberRegistrar.findByDataId(dataId);
            clientIds = new String[subscribers.size()];
            int i = 0;
            for (DefaultSubscriber subscriber : subscribers) {
                clientIds[i++] = subscriber.getClientId();
            }
        }
        return clientIds;
    }

    private List<Object> getDataList(boolean isGzip, String dataId, Revision revision, UserDataElement element) throws IOException {
        List<Object> data = null;
        if (isGzip) {
            data = ZipUtil.getPushDataFromZipContent(element);
        } else {
            data = element.getActualData();
        }
        if (data == null || data.size() < 1) {
            log.info("[Data-received] (ID: " + dataId + ", Revision: " + revision + ", Empty)");
        } else {
            Object sample;
            if (data.size() != element.size() && !isGzip) {
                log.info("[Internal] Some unrecognized or corrupted data may be dropped. (Reported: " + element.size() + ", Actual: " + data.size() + ")");
            }
            if ((sample = data.get(0)) instanceof String) {
                String slug = (String)sample;
                if (slug.length() > 256) {
                    slug = slug.substring(0, 256) + " ...";
                }
                log.info("[Data-received] (ID: " + dataId + ", Revision: " + revision + ", Count: " + data.size() + ", gzip=" + isGzip + ", String[0]: " + slug + ")");
            } else {
                log.info("[Data-received] (ID: " + dataId + ", Revision: " + revision + ", Count: " + data.size() + ", Class[0]: " + sample.getClass().getSimpleName() + ")");
            }
        }
        return data;
    }
}

