/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client.processor;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.processor.ProtocolElementProcessor;
import com.taobao.config.common.protocol.ProtocolElement;
import com.taobao.config.common.protocol.ProtocolPackage;
import com.taobao.middleware.logger.Logger;
import java.util.HashMap;
import java.util.Map;

public class ElementProcessorHub {
    private static final Logger logger = ConfigClientLogger.getLogger(ElementProcessorHub.class);
    private final Map<Class<?>, ProtocolElementProcessor> messageProcessors = new HashMap();

    public void processMessage(ProtocolElement input, ProtocolPackage pp) {
        ProtocolElementProcessor processor = this.getMessageProcessor(input);
        if (processor != null) {
            logger.debug("[Message] Processing " + input.getClass().getSimpleName());
            processor.process(input, pp);
        }
    }

    private ProtocolElementProcessor getMessageProcessor(ProtocolElement input) {
        ProtocolElementProcessor processor = this.messageProcessors.get(input.getClass());
        if (processor != null) {
            return processor;
        }
        String className = this.getClass().getPackage().getName() + "." + input.getClass().getSimpleName() + "Processor";
        try {
            Class<?> clazz = Class.forName(className);
            Object instance = clazz.newInstance();
            if (instance instanceof ProtocolElementProcessor) {
                processor = (ProtocolElementProcessor)instance;
                this.messageProcessors.put(input.getClass(), processor);
            }
            return processor;
        }
        catch (Exception e) {
            logger.error("%s", "error create processor of type " + className + ", " + e.toString(), e);
            return null;
        }
    }
}

