/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client.failover;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.DefaultSubscriber;
import com.taobao.config.client.EventDispatcher;
import com.taobao.config.client.Events;
import com.taobao.config.client.RunMode;
import com.taobao.config.client.SubscriberRegistrar;
import com.taobao.config.client.failover.CheckFailoverForUpdateTask;
import com.taobao.config.client.failover.FailoverDataParser;
import com.taobao.middleware.logger.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FailoverModeListener
extends EventDispatcher.EventListener {
    private static final Logger log = ConfigClientLogger.getLogger(FailoverModeListener.class);

    @Override
    public List<Class<? extends EventDispatcher.Event>> interest() {
        ArrayList<Class<? extends EventDispatcher.Event>> eventTypes = new ArrayList<Class<? extends EventDispatcher.Event>>();
        eventTypes.add(Events.RunModeChangeEvent.class);
        eventTypes.add(Events.AddSubscriberEvent.class);
        return eventTypes;
    }

    @Override
    public void onEvent(EventDispatcher.Event event) {
        if (event instanceof Events.RunModeChangeEvent) {
            if (RunMode.isFailoverMode()) {
                this.onChangeToFailover();
            } else {
                this.onChangeToNormal();
            }
        } else if (event instanceof Events.AddSubscriberEvent) {
            this.onAddSubscriber((Events.AddSubscriberEvent)event);
        }
    }

    void onChangeToFailover() {
        if (RunMode.isFailoverMode()) {
            log.warn("########## [run-mode] change to [failover] mode.");
            Iterator<DefaultSubscriber> iter = SubscriberRegistrar.subscriberIterator();
            while (iter.hasNext()) {
                DefaultSubscriber sub = iter.next();
                sub.onServerDisconnected();
                String dataId = sub.getDataId();
                String groupId = sub.getRegistration().getGroup();
                FailoverDataParser.copySnapshotToFailover(dataId, groupId, sub.getServerListManager().getEnv());
                CheckFailoverForUpdateTask.createAndSchedule(sub);
            }
        }
    }

    void onAddSubscriber(Events.AddSubscriberEvent event) {
        if (RunMode.isFailoverMode()) {
            String dataId = event.subscriber.getDataId();
            String groupId = event.subscriber.getRegistration().getGroup();
            FailoverDataParser.copySnapshotToFailover(dataId, groupId, event.subscriber.getServerListManager().getEnv());
            CheckFailoverForUpdateTask.createAndSchedule(event.subscriber);
        }
    }

    void onChangeToNormal() {
        if (RunMode.isNormalMode()) {
            log.warn("########## [run-mode] change to [normal] mode.");
            Iterator<DefaultSubscriber> iter = SubscriberRegistrar.subscriberIterator();
            while (iter.hasNext()) {
                iter.next().onServerDisconnected();
            }
        }
    }
}

