/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client.failover;

import com.taobao.config.client.CachePersist;
import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.LocalConfigInfo;
import com.taobao.config.client.utils.IOUtils;
import com.taobao.middleware.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;

class FailoverDataParser {
    static final String DATA_FILE_PATTERN = LocalConfigInfo.FAILOVER_DATA_PATH + "/{0}/{1}.dat";
    private static final Logger log = ConfigClientLogger.getLogger(FailoverDataParser.class);

    FailoverDataParser() {
    }

    public static List<Object> getFailoverData(String dataId, String groupId) {
        return CachePersist.parse(FailoverDataParser.getFailoverFile(dataId, groupId));
    }

    static void copySnapshotToFailover(String dataId, String groupId, String env) {
        File lastestSnapshot = CachePersist.latestSnapshot(dataId, groupId, env, false);
        if (null == lastestSnapshot) {
            log.error("%s", "########## [copy-snapshot] snapshot not found. dataId: " + dataId + ", groupId: " + groupId);
            return;
        }
        String failoverPath = MessageFormat.format(DATA_FILE_PATTERN, dataId, groupId);
        File failoverFile = new File(failoverPath);
        if (failoverFile.exists() && failoverFile.lastModified() >= lastestSnapshot.lastModified()) {
            log.info("failover is newer than snapshot, donot need override." + failoverFile.getAbsolutePath());
            return;
        }
        try {
            IOUtils.copyFile(lastestSnapshot.getAbsolutePath(), failoverPath);
            log.info("########## [copy-snapshot] Success to copy " + lastestSnapshot.getAbsolutePath() + " to " + failoverPath);
        }
        catch (IOException ioe) {
            log.error("%s", "########## [copy-snapshot] Failed to copy " + lastestSnapshot.getAbsolutePath() + " to " + failoverPath);
        }
    }

    public static Long getLastModified(String dataId, String groupId) {
        File dataFile = FailoverDataParser.getFailoverFile(dataId, groupId);
        return dataFile.exists() ? Long.valueOf(dataFile.lastModified()) : null;
    }

    public static File getFailoverFile(String dataId, String groupId) {
        String dataFileStr = MessageFormat.format(DATA_FILE_PATTERN, dataId, groupId);
        File dataFile = new File(dataFileStr);
        return dataFile;
    }
}

