/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client.exception;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.exception.ExcEvent;
import com.taobao.config.client.exception.ExcListener;
import com.taobao.config.client.exception.ExcRole;
import com.taobao.config.client.utils.StringUtils;
import com.taobao.middleware.logger.Logger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class ExcEventDispatch {
    private static final Logger logger = ConfigClientLogger.getLogger(ExcEventDispatch.class);
    private static final Map<String, ExcListener> listeners = new HashMap<String, ExcListener>();
    private static final LinkedBlockingQueue<ExcEvent> events = new LinkedBlockingQueue();
    public static final AtomicBoolean isInit = new AtomicBoolean(false);
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor();

    public static void init() {
        if (isInit.compareAndSet(false, true)) {
            executorService.execute(new ProcessThread());
        }
    }

    public static void addListener(String dataId, String groupId, String tenant, ExcRole er, ExcListener listener) {
        listeners.put(StringUtils.join(new Object[]{dataId, groupId, tenant, er.name()}, '#'), listener);
    }

    public static void fireEvent(ExcEvent e) {
        if (null == e) {
            throw new IllegalArgumentException("Illegal Exception Event");
        }
        events.add(e);
    }

    private static class ProcessThread
    implements Runnable {
        private ProcessThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    block6: while (true) {
                        ExcEvent exception = (ExcEvent)events.take();
                        Iterator iterator = listeners.entrySet().iterator();
                        block7: while (true) {
                            if (!iterator.hasNext()) continue block6;
                            Map.Entry entry = iterator.next();
                            switch (exception.getExcType().getExcRole()) {
                                case COMMON: {
                                    ((ExcListener)entry.getValue()).onEvent(exception);
                                    continue block7;
                                }
                            }
                            if (!exception.getKey().equals(entry.getKey())) continue;
                            ((ExcListener)entry.getValue()).onEvent(exception);
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    logger.error("%s", "[Error ExcEvent processThread]", e);
                    continue;
                }
                break;
            }
        }
    }
}

