/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client;

import com.taobao.config.client.DataClientRegistration;
import com.taobao.config.client.utils.StringUtils;
import java.io.Serializable;
import java.util.List;

public class SubscriberRegistration
extends DataClientRegistration {
    public SubscriberRegistration(String subscriberName, String dataId) {
        super(subscriberName, dataId, null);
        this.setAttribute("!RegistrantTrack", new Throwable());
    }

    public SubscriberRegistration(String subscriberName, String dataId, String datumId) {
        super(subscriberName, dataId, datumId);
        this.setAttribute("!RegistrantTrack", new Throwable());
    }

    public void setCacheable(boolean cacheable) {
    }

    public boolean isCacheable() {
        return true;
    }

    public void setSubIpGroupList(List<String> ipGroupList) {
        if (ipGroupList != null) {
            StringBuilder ipGroupStrbuilder = new StringBuilder();
            for (int i = 0; i < ipGroupList.size(); ++i) {
                String ipGroup = ipGroupList.get(i);
                if (!StringUtils.isNotBlank(ipGroup)) continue;
                ipGroupStrbuilder.append(ipGroup);
                if (i == ipGroupList.size() - 1) continue;
                ipGroupStrbuilder.append(",");
            }
            String ipGroupStr = ipGroupStrbuilder.toString();
            if (StringUtils.isNotBlank(ipGroupStr)) {
                this.setAttribute("!SubIpGroups", (Serializable)((Object)ipGroupStr));
            }
        }
    }

    public String getSubIpGroups() {
        return (String)((Object)this.getAttribute("!SubIpGroups"));
    }

    public String getSubscriberName() {
        return this.getClientName();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("Subscriber \"" + this.getClientId() + "\" ");
        buffer.append("[Data ID: " + this.getDataId() + "]");
        String group = this.getGroup();
        if (group != null) {
            buffer.append("[Group: " + group + "]");
        }
        if (this.isCacheable()) {
            buffer.append("[Cacheable]");
        }
        buffer.append("[Tenant: " + this.getTenant() + "]");
        buffer.append("[subIpGroups: " + this.getSubIpGroups() + "]");
        return buffer.toString();
    }
}

