/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.ConfigClientPerfCtrl;
import com.taobao.config.client.ServerListManager;
import com.taobao.config.client.bean.InstanceMetaData;
import com.taobao.config.client.utils.StringUtils;
import com.taobao.middleware.logger.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServerListManagerFactory {
    private static final Logger logger = ConfigClientLogger.getLogger(ServerListManagerFactory.class);
    private static final ConcurrentHashMap<String, List<ServerListManager>> serverListManagerPool = new ConcurrentHashMap();
    private static String defaultMrgKey = "defaultMrgKey";

    public static ServerListManager getDefaultServerListManager(String conType, InstanceMetaData instanceMetaData) {
        String instanceKey = null;
        if (instanceMetaData != null) {
            instanceKey = instanceMetaData.getConnectKey();
        }
        return ServerListManagerFactory.getAvailableManager(null, defaultMrgKey, conType, instanceKey);
    }

    public static synchronized ServerListManager getServerListManager(String attr, String value, String conType, InstanceMetaData instanceMetaData) {
        if (!"!Center".equals(attr) && !"!Server".equals(attr)) {
            String message = "[Global] Set LocalAttribute: " + attr + " ,Error ,Check your code";
            logger.error("%s", message);
            throw new IllegalArgumentException(message);
        }
        String instanceKey = null;
        if (instanceMetaData != null) {
            instanceKey = instanceMetaData.getConnectKey();
        }
        return ServerListManagerFactory.getAvailableManager(attr, value, conType, instanceKey);
    }

    private static synchronized ServerListManager getAvailableManager(String attr, String key, String conType, String instanceKey) {
        String poolKey = key = key.trim();
        if (StringUtils.isNotBlank(instanceKey)) {
            instanceKey = instanceKey.trim();
            poolKey = key + "-" + instanceKey;
        }
        ServerListManager mgr = null;
        List<ServerListManager> serverListManagers = ServerListManagerFactory.getServerListManagerList(poolKey);
        for (ServerListManager serverListManager : serverListManagers) {
            if (ConfigClientPerfCtrl.isMultiConnections() && (conType == null && (serverListManager.pubCountOverflow() || serverListManager.subCountOverflow()) || "pub".equals(conType) && serverListManager.pubCountOverflow() || "pub".equals(conType) && serverListManager.subCountOverflow())) continue;
            mgr = serverListManager;
            break;
        }
        if (mgr == null) {
            mgr = attr == null ? ServerListManagerFactory.createServerManager(instanceKey) : ("!Center".equals(attr) ? ServerListManagerFactory.createServerManager(key, instanceKey) : ("!Server".equals(attr) ? ServerListManagerFactory.createServerManager(key.split(";"), instanceKey) : ServerListManagerFactory.createServerManager(instanceKey)));
            serverListManagers.add(mgr);
        }
        return mgr;
    }

    private static synchronized List<ServerListManager> getServerListManagerList(String key) {
        List<ServerListManager> serverListManagers = serverListManagerPool.get(key);
        if (serverListManagers == null) {
            serverListManagers = new ArrayList<ServerListManager>(0);
            serverListManagerPool.put(key, serverListManagers);
        }
        return serverListManagers;
    }

    private static ServerListManager createServerManager(String center, String instanceMetaStr) {
        ServerListManager s = new ServerListManager(center, instanceMetaStr);
        s.start();
        return s;
    }

    private static ServerListManager createServerManager(String instanceMetaStr) {
        ServerListManager s = new ServerListManager(instanceMetaStr);
        s.start();
        return s;
    }

    private static ServerListManager createServerManager(String[] serverUrls, String instanceMetaStr) {
        ArrayList<String> fixed = new ArrayList<String>(serverUrls.length);
        for (String url : serverUrls) {
            fixed.add(url);
        }
        ServerListManager s = new ServerListManager(fixed, instanceMetaStr);
        s.start();
        return s;
    }

    public static List<String> dumpConnectionStatus() {
        try {
            ArrayList<String> mgrConnectionStatus = new ArrayList<String>();
            for (Map.Entry<String, List<ServerListManager>> entry : serverListManagerPool.entrySet()) {
                ArrayList serverListManagers = new ArrayList(entry.getValue());
                for (ServerListManager serverListManager : serverListManagers) {
                    mgrConnectionStatus.add(serverListManager.getConnectionsStatus());
                }
            }
            return mgrConnectionStatus;
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    public static String dumpDetail() {
        try {
            StringBuffer sb = new StringBuffer();
            for (Map.Entry<String, List<ServerListManager>> entry : serverListManagerPool.entrySet()) {
                ArrayList serverListManagers = new ArrayList(entry.getValue());
                for (ServerListManager serverListManager : serverListManagers) {
                    sb.append("\n" + serverListManager);
                }
            }
            return "[server-list-mgr-new]" + sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static List<String> parseServerListStr(String value) {
        String[] urlList = value.split(";");
        ArrayList<String> fixed = new ArrayList<String>(urlList.length);
        for (String url : urlList) {
            fixed.add(url);
        }
        return fixed;
    }
}

