/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client;

import com.taobao.config.client.CachePersist;
import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.ConfigClientPerfCtrl;
import com.taobao.config.client.ConfigClientSetting;
import com.taobao.config.client.ConfigClientTimerService;
import com.taobao.config.client.ConfigClientWorker;
import com.taobao.config.client.ConnectionProxy;
import com.taobao.config.client.ServerAddressIterator;
import com.taobao.config.client.exception.ConfigClientException;
import com.taobao.config.client.http.HttpResult;
import com.taobao.config.client.utils.HttpUtils;
import com.taobao.config.client.utils.StringUtils;
import com.taobao.config.common.ConfigServerURL;
import com.taobao.middleware.logger.Logger;
import com.taobao.remoting.Connection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ServerListManager {
    static final Logger log = ConfigClientLogger.getLogger(ServerListManager.class);
    final boolean isFixed;
    volatile String center = null;
    volatile boolean isStarted = false;
    volatile List<String> serverUrls = new ArrayList<String>();
    final ConnectionProxy connectionProxy;
    AtomicLong pubCount = new AtomicLong();
    AtomicLong subCount = new AtomicLong();
    private String env = "DEFAULT_ENV";
    private String instanceMetaStr = null;
    private static final ExecutorService workerPool = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("ConfigClientWorker-Thread");
            return t;
        }
    });
    private ConfigClientWorker configClientWork = new ConfigClientWorker(this);

    public ConfigClientWorker getConfigClientWork() {
        return this.configClientWork;
    }

    private void executeConfigClientWork() {
        workerPool.execute(this.configClientWork);
    }

    public ServerListManager(String instanceMetaStr) {
        this.executeConfigClientWork();
        this.isFixed = false;
        this.isStarted = false;
        this.env = "DEFAULT_ENV";
        this.instanceMetaStr = instanceMetaStr;
        if (StringUtils.isNotBlank(this.instanceMetaStr)) {
            this.env = this.env + "-" + this.instanceMetaStr;
        }
        this.connectionProxy = new ConnectionProxy(this);
    }

    public ServerListManager(String center, String instanceMetaStr) {
        this.executeConfigClientWork();
        this.center = center;
        this.isFixed = false;
        this.isStarted = false;
        this.env = center;
        this.instanceMetaStr = instanceMetaStr;
        if (StringUtils.isNotBlank(this.instanceMetaStr)) {
            this.env = this.env + "-" + this.instanceMetaStr;
        }
        this.connectionProxy = new ConnectionProxy(this);
    }

    public ServerListManager(List<String> fixed, String instanceMetaStr) {
        this.executeConfigClientWork();
        this.isFixed = true;
        this.isStarted = true;
        this.env = fixed.toString();
        this.instanceMetaStr = instanceMetaStr;
        if (StringUtils.isNotBlank(this.instanceMetaStr)) {
            this.env = this.env + "-" + this.instanceMetaStr;
        }
        this.serverUrls = new ArrayList<String>(fixed);
        this.connectionProxy = new ConnectionProxy(this);
    }

    public void start() {
        if (this.isStarted || this.isFixed) {
            return;
        }
        for (int i = 0; i < 3 && this.serverUrls.isEmpty(); ++i) {
            new GetServerListTask().run();
        }
        if (this.serverUrls.isEmpty()) {
            if (!Boolean.getBoolean("CS.NOSERVER.NOEXIT")) {
                log.error("%s", "########## cannot get serverlist, so exit jvm env=" + this.env);
                new ConfigClientException("Env-error", "cannot get serverlist, so exit jvm env=" + this.env).printStackTrace();
                System.exit(0);
            } else {
                log.error("%s", "########## cannot get serverlist, should exit jvm, but jvm args CS.NOSERVER.NOEXIT=true env=" + this.env);
            }
        }
        ConfigClientTimerService.timer.scheduleWithFixedDelay(new GetServerListTask(), 0L, 30L, TimeUnit.SECONDS);
        this.isStarted = true;
    }

    Connection getConnection() {
        return null == this.connectionProxy.client ? null : this.connectionProxy.client.getConnection();
    }

    List<String> getServerUrls() {
        return new ArrayList<String>(this.serverUrls);
    }

    public Iterator<ConfigServerURL> iterator() {
        if (this.serverUrls.isEmpty()) {
            log.error("%s", "[serverlist] No server address defined!");
        }
        return new ServerAddressIterator(this.serverUrls);
    }

    private void updateIfChanged(List<String> newList) {
        if (newList.isEmpty()) {
            log.warn("[serverlist] get empty serverlist from apache.");
            return;
        }
        if (this.serverUrls.equals(newList)) {
            return;
        }
        this.serverUrls = new ArrayList<String>(newList);
        CachePersist.save("com.taobao.config.serverlist", null, this.serverUrls, this.env);
        Connection connection = this.getConnection();
        if (connection != null && !this.serverUrls.contains(connection.getRemoteAddress())) {
            this.connectionProxy.close();
            log.warn("[close-connection] when serverlist updated." + connection);
        }
        this.configClientWork.closeConnection();
        log.warn("[serverlist] updated to " + this.serverUrls + "domain=" + ConfigClientSetting.getAddressServerDomain() + ":" + ConfigClientSetting.getAddressServerPort());
    }

    public List<String> queryServerlist() {
        return this.getApacheServerList();
    }

    public static String addressServerUrl(String center) {
        String domain = ConfigClientSetting.getAddressServerDomain() + ":" + ConfigClientSetting.getAddressServerPort();
        String url = "http://" + domain + "/configserver/serverlist";
        if (center != null && !center.equals("default") && !center.equals("DEFAULT_ENV")) {
            url = url + "-" + center + "?nofix=1";
        }
        return url;
    }

    public static List<String> getServerListByAs(String center) {
        String url = ServerListManager.addressServerUrl(center);
        try {
            HttpResult httpResult = HttpUtils.invokeURL(url);
            if (200 == httpResult.code) {
                return HttpUtils.httpResultLines(httpResult);
            }
            if (404 == httpResult.code) {
                log.error("%s", "[serverlist] failed to get serverlist from " + url + ", error code " + httpResult.code + " Cause by IllegalCenter set as  " + center);
                return Collections.emptyList();
            }
            log.error("%s", "[serverlist] failed to get serverlist from " + url + ", error code " + httpResult.code);
            return Collections.emptyList();
        }
        catch (IOException e) {
            log.warn("[serverlist] exception, " + url + ", " + e.toString(), e);
            return Collections.emptyList();
        }
    }

    List<String> getApacheServerList() {
        return ServerListManager.getServerListByAs(this.center);
    }

    public void incrementPubCount() {
        this.pubCount.incrementAndGet();
    }

    public void decrementPubCount() {
        this.pubCount.decrementAndGet();
    }

    public boolean pubCountOverflow() {
        return this.pubCount.get() >= (long)ConfigClientPerfCtrl.maxPubCountPerConn;
    }

    public boolean subCountOverflow() {
        return this.subCount.get() >= (long)ConfigClientPerfCtrl.maxSubCountPerConn;
    }

    public void incrementSubCount() {
        this.subCount.incrementAndGet();
    }

    public void decrementSubCount() {
        this.subCount.decrementAndGet();
    }

    public String getConnectionsStatus() {
        return this.env + "|" + this.connectionProxy.getReConnected();
    }

    public String getCenter() {
        return this.center;
    }

    public String getEnv() {
        return this.env;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("env=" + this.env);
            stringBuffer.append(",serverUrls=" + this.serverUrls.toString());
            stringBuffer.append(",pubCount=" + this.pubCount.get());
            stringBuffer.append(",subCount=" + this.subCount.get());
            stringBuffer.append(",reConnected=" + this.connectionProxy.getReConnected());
            Connection connection = this.getConnection();
            if (connection != null) {
                stringBuffer.append(",connection=" + connection);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    class GetServerListTask
    implements Runnable {
        GetServerListTask() {
        }

        @Override
        public void run() {
            try {
                ServerListManager.this.updateIfChanged(ServerListManager.this.getApacheServerList());
            }
            catch (Exception e) {
                log.error("%s", "[serverlist] failed to get serverlist, " + e.toString(), e);
            }
        }
    }
}

