/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client;

import com.taobao.config.client.bean.ObserverData;
import com.taobao.config.client.utils.ObserverDataUtils;
import com.taobao.config.common.Revision;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

class RevisedData
implements Serializable {
    private final List<Object> data;
    private Map<String, List<ObserverData>> observerDataGroups;
    private final Revision revision;
    private static final long serialVersionUID = 1L;

    public RevisedData(List<Object> data, Revision revision) {
        this.data = data;
        this.observerDataGroups = ObserverDataUtils.getObserverDataMapFromData(data);
        this.revision = revision;
    }

    public RevisedData(List<Object> data, Revision revision, Map<String, List<ObserverData>> observerDataGroups) {
        this.data = data;
        this.revision = revision;
        this.observerDataGroups = observerDataGroups;
    }

    public RevisedData(Revision revision, Map<String, List<ObserverData>> observerDataGroups) {
        this.observerDataGroups = observerDataGroups;
        this.data = ObserverDataUtils.getDataFromObserverDataMap(observerDataGroups);
        this.revision = revision;
    }

    public List<Object> getData() {
        return this.data;
    }

    public Map<String, List<ObserverData>> getObserverDataGroups() {
        return this.observerDataGroups;
    }

    public Revision getRevision() {
        return this.revision;
    }

    public String toString() {
        return "RevisedData(" + this.revision.getRevision() + ", " + (this.data != null ? this.data.toString() : "null") + ", " + (this.observerDataGroups != null ? this.observerDataGroups.toString() : "null") + ")";
    }
}

