/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client;

import com.taobao.config.client.DataClientRegistration;
import java.io.Serializable;
import java.security.InvalidParameterException;

public class PublisherRegistration<T extends Serializable>
extends DataClientRegistration {
    public PublisherRegistration(String publisherName, String dataId) {
        this(publisherName, dataId, null);
    }

    public PublisherRegistration(String publisherName, String dataId, String datumId) {
        super(publisherName, dataId, datumId);
    }

    public String getPublisherName() {
        return this.getClientName();
    }

    public void setPersistency(boolean state) {
        if (state && this.getDatumId() == null) {
            throw new InvalidParameterException("Publisher without specified datum ID is not persistable.");
        }
        this.setAttribute("!Persist", Boolean.valueOf(state));
    }

    public boolean getPersistency() {
        Boolean state = (Boolean)this.getAttribute("!Persist");
        if (state == null) {
            return false;
        }
        return state;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("Publisher \"" + this.getClientId() + "\" ");
        buffer.append("[Data ID: " + this.getDataId() + "]");
        String group = this.getGroup();
        if (group != null) {
            buffer.append("[Group: " + group + "]");
        }
        if (this.getPersistency()) {
            buffer.append("[Persistent]");
        }
        buffer.append("[Tenant: " + this.getTenant() + "]");
        return buffer.toString();
    }
}

