/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.ConfigClientPerfCtrl;
import com.taobao.config.client.DefaultPublisher;
import com.taobao.config.client.Initialization;
import com.taobao.config.client.Publisher;
import com.taobao.config.client.PublisherRegistration;
import com.taobao.config.client.utils.StringUtils;
import com.taobao.middleware.logger.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PublisherRegistrar {
    private static final Logger log = ConfigClientLogger.getLogger(PublisherRegistrar.class);
    protected static final Map<String, DefaultPublisher<?>> clients = new ConcurrentHashMap();

    public static synchronized <T extends Serializable> Publisher<T> register(PublisherRegistration<T> registration) {
        if (null == registration) {
            throw new IllegalArgumentException("registration is null");
        }
        String dataId = registration.getDataId();
        if (dataId.length() > ConfigClientPerfCtrl.dataIdLengthMax) {
            throw new IllegalArgumentException("dataId length bigger than " + ConfigClientPerfCtrl.dataIdLengthMax + " :" + dataId);
        }
        String groupId = registration.getGroup();
        if (groupId.length() > ConfigClientPerfCtrl.groupLengthMax) {
            throw new IllegalArgumentException("group length bigger than " + ConfigClientPerfCtrl.groupLengthMax + " :" + groupId);
        }
        String clientId = registration.getClientId();
        if (clientId.length() > ConfigClientPerfCtrl.publisherNameLengthMax) {
            throw new IllegalArgumentException("publisherName length bigger than " + ConfigClientPerfCtrl.publisherNameLengthMax + " :" + clientId);
        }
        if (clients.size() >= ConfigClientPerfCtrl.pubCountMax) {
            throw new IllegalArgumentException("publisher count bigger than " + ConfigClientPerfCtrl.pubCountMax);
        }
        String tenant = registration.getTenant();
        DefaultPublisher<Object> publisher = PublisherRegistrar.findExisting(registration);
        if (null != publisher) {
            log.info("########## [reuse-publisher] " + publisher);
            return publisher;
        }
        log.info("[Registrar] Register new publisher. dataId=" + dataId + ", groupId=" + groupId + ", clientId=" + clientId + ", tenant=" + tenant + ", !Server=" + registration.getLocalAttribute("!Server") + ", !Center=" + registration.getLocalAttribute("!Center"));
        try {
            publisher = new DefaultPublisher<T>(registration);
            clients.put(clientId, publisher);
        }
        catch (Exception e) {
            log.error("%s", "[Internal] Exception in registering subscriber: ", e);
        }
        return publisher;
    }

    public static boolean unregister(Publisher<?> publisher) {
        if (null == publisher) {
            throw new IllegalArgumentException("publisher is null");
        }
        log.info("[Registrar] Unregister " + publisher.getRegistration());
        try {
            ((DefaultPublisher)publisher).unregister();
            return true;
        }
        catch (Exception e) {
            log.error("%s", "[Internal] Exception in unregistering subscriber: ", e);
            return false;
        }
    }

    public static DefaultPublisher<?> find(String clientId) {
        return clients.get(clientId);
    }

    static synchronized boolean remove(Publisher<?> publisher) {
        return clients.remove(publisher.getClientId()) != null;
    }

    static DefaultPublisher<?> findExisting(PublisherRegistration<?> preg) {
        String dataId = preg.getDataId();
        String groupId = preg.getGroup();
        String tenant = preg.getTenant();
        String server = (String)preg.getLocalAttribute("!Server");
        String center = (String)preg.getLocalAttribute("!Center");
        for (DefaultPublisher<?> publisher : clients.values()) {
            String p_dataId = publisher.getDataId();
            String p_groupId = ((PublisherRegistration)publisher.getRegistration()).getGroup();
            String p_tenant = ((PublisherRegistration)publisher.getRegistration()).getTenant();
            String p_server = (String)((PublisherRegistration)publisher.getRegistration()).getLocalAttribute("!Server");
            String p_center = (String)((PublisherRegistration)publisher.getRegistration()).getLocalAttribute("!Center");
            if (!publisher.isEnable() || !p_dataId.equals(dataId) || !p_groupId.equals(groupId) || !p_tenant.equals(tenant)) continue;
            if (center != null && p_center != null && p_center.equals(center)) {
                return publisher;
            }
            if (center != null || p_center != null || !StringUtils.equals(p_server, server)) continue;
            return publisher;
        }
        return null;
    }

    public static Iterator<DefaultPublisher<?>> publisherIterator() {
        return clients.values().iterator();
    }

    public static Collection<DefaultPublisher<?>> AllPublishers() {
        return Collections.unmodifiableCollection(clients.values());
    }

    static {
        new Initialization();
    }
}

