/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client;

import com.taobao.config.client.CachePersist;
import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.ServerListManager;
import com.taobao.middleware.logger.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EnvironmentProbe {
    private static final Logger log = ConfigClientLogger.getLogger(EnvironmentProbe.class);

    public static void probe() {
        if (EnvironmentProbe.isEnvironmentChanged()) {
            log.warn("########## environment changed. clear cache.");
            CachePersist.clear();
        } else {
            log.info("########## environment ok.");
        }
    }

    static boolean isEnvironmentChanged() {
        List<String> cacheUrls = EnvironmentProbe.serverUrlsFromCache();
        List<String> apacheUrls = ServerListManager.getServerListByAs(null);
        log.info("[apache-urls] " + apacheUrls);
        log.info("[cache-urls] " + cacheUrls);
        return !apacheUrls.equals(cacheUrls);
    }

    static List<String> serverUrlsFromCache() {
        List<Object> cacheData = CachePersist.initialData("com.taobao.config.serverlist", null, "DEFAULT_ENV");
        if (null == cacheData || cacheData.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> urls = new ArrayList<String>();
        for (Object item : cacheData) {
            urls.add((String)item);
        }
        return urls;
    }
}

