/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client;

import com.taobao.config.client.CachePersist;
import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.ConfigClientNotifier;
import com.taobao.config.client.DefaultDataClient;
import com.taobao.config.client.DefaultSubscription;
import com.taobao.config.client.LocalConfigInfo;
import com.taobao.config.client.RevisedData;
import com.taobao.config.client.ServerListManager;
import com.taobao.config.client.ServerListManagerFactory;
import com.taobao.config.client.SubMetaDataObserver;
import com.taobao.config.client.SubWeightDataObserver;
import com.taobao.config.client.Subscriber;
import com.taobao.config.client.SubscriberDataObserver;
import com.taobao.config.client.SubscriberRegistration;
import com.taobao.config.client.Subscription;
import com.taobao.config.client.WeightDataObserver;
import com.taobao.config.client.bean.InstanceMetaData;
import com.taobao.config.client.bean.ObserverData;
import com.taobao.config.client.exception.ExcEventDispatch;
import com.taobao.config.client.exception.ExcListener;
import com.taobao.config.client.exception.ExcRole;
import com.taobao.config.client.utils.AttributeUtils;
import com.taobao.config.client.utils.MapUtils;
import com.taobao.config.client.utils.StringUtils;
import com.taobao.config.common.Revision;
import com.taobao.config.common.protocol.AttributeElement;
import com.taobao.config.common.protocol.ProtocolPackage;
import com.taobao.config.common.protocol.SubscriberRegReqPacket;
import com.taobao.middleware.logger.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultSubscriber
extends DefaultDataClient
implements Subscriber {
    private volatile Map<String, Double> weightValue = new HashMap<String, Double>();
    public volatile boolean isExistSubMetaDataObserver = false;
    private AtomicInteger dataPushCount = new AtomicInteger();
    private AtomicInteger weightPushCount = new AtomicInteger();
    protected static final Logger log = ConfigClientLogger.getLogger(DefaultSubscriber.class);
    private final SubscriberRegReqPacket regRequest;
    private volatile RevisedData data;
    protected final CopyOnWriteArrayList<SubscriberDataObserver> observers;

    public Map<String, Double> getWeightValue() {
        return this.weightValue;
    }

    public boolean setWeightValue(Map<String, Double> weightValue) {
        if (!this.weightValue.equals(weightValue)) {
            this.weightPushCount.incrementAndGet();
            this.weightValue = weightValue;
            return true;
        }
        return false;
    }

    @Override
    public List<Object> peekData() {
        if (this.data.getData() == null) {
            return null;
        }
        try {
            return Collections.unmodifiableList(this.data.getData());
        }
        catch (Throwable t) {
            return null;
        }
    }

    public Map<String, List<ObserverData>> peekDataWithMeta() {
        if (this.data.getObserverDataGroups() == null) {
            return null;
        }
        try {
            return Collections.unmodifiableMap(this.data.getObserverDataGroups());
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public SubscriberRegistration getRegistration() {
        return (SubscriberRegistration)this.registration;
    }

    public DefaultSubscriber(SubscriberRegistration registration) {
        super(registration);
        this.regRequest = new SubscriberRegReqPacket(registration.getDataId(), registration.getClientId(), registration.getDatumId());
        for (Map.Entry attribute : registration.getAllAttributes()) {
            this.regRequest.setAttribute((String)attribute.getKey(), (Serializable)attribute.getValue());
        }
        this.observers = new CopyOnWriteArrayList();
        List<Object> initial = CachePersist.initialData(this.getDataId(), this.getRegistration().getGroup(), this.serverMgr.getEnv());
        Map<String, List<ObserverData>> initialWithMeta = CachePersist.initialDataWithMeta(this.getDataId(), this.getRegistration().getGroup(), this.serverMgr.getEnv());
        if (!MapUtils.isEmptyValue(initialWithMeta)) {
            this.data = new RevisedData(Revision.UNINITIALIZED_REVISION, initialWithMeta);
            log.info("[init-subscriber] " + this + ", initial dataWithMeta, dataMsg=" + this.getDataMsg(initialWithMeta));
        } else if (null != initial && !initial.isEmpty()) {
            this.data = new RevisedData(initial, Revision.UNINITIALIZED_REVISION);
            log.info("[init-subscriber] " + this + ", initial data, dataSize=" + initial.size());
        } else {
            this.data = new RevisedData(null, Revision.UNINITIALIZED_REVISION, null);
            log.info("[init-subscriber] no init data file. " + this);
        }
        this.serverMgr.incrementSubCount();
        this.signalWorker();
    }

    public synchronized void unregister() {
        boolean unregister = super.setDisable();
        if (unregister) {
            this.serverMgr.decrementSubCount();
        }
    }

    @Override
    public synchronized void setDataObserver(SubscriberDataObserver observer) {
        this.observers.addIfAbsent(observer);
        if (observer instanceof SubMetaDataObserver) {
            this.isExistSubMetaDataObserver = true;
            if (null != this.data.getObserverDataGroups()) {
                ((SubMetaDataObserver)observer).handleDataWithMeta(this.getDataId(), this.data.getObserverDataGroups());
            }
        }
        if (null != this.data.getData()) {
            if (observer instanceof SubscriberDataObserver.NewDataObserver && this.data.getRevision().equals(Revision.UNINITIALIZED_REVISION)) {
                ((SubscriberDataObserver.NewDataObserver)observer).onInitialLocalData(this.data.getData());
            } else if (observer instanceof WeightDataObserver) {
                Map<String, Double> readOnlyMapView = Collections.unmodifiableMap(this.weightValue);
                ((WeightDataObserver)observer).handleData(this.getDataId(), this.data.getData(), readOnlyMapView);
            } else if (observer instanceof SubWeightDataObserver) {
                ((SubWeightDataObserver)observer).handleData(this.getDataId(), this.data.getData());
            } else if (!(observer instanceof SubMetaDataObserver)) {
                observer.handleData(this.getDataId(), this.data.getData());
            }
        }
    }

    @Override
    @Deprecated
    public SubscriberDataObserver getDataObserver() {
        return this.observers.isEmpty() ? null : this.observers.get(0);
    }

    @Override
    public synchronized Subscription getSubscription() {
        DefaultSubscription observer = new DefaultSubscription();
        this.setDataObserver(observer);
        return observer;
    }

    @Override
    ServerListManager initServerManager() {
        String server = (String)this.registration.getLocalAttribute("!Server");
        String center = (String)this.registration.getLocalAttribute("!Center");
        InstanceMetaData instanceMetaData = this.registration.getInstanceMetaData();
        if (StringUtils.isNotBlank(center)) {
            return ServerListManagerFactory.getServerListManager("!Center", center, "pub", instanceMetaData);
        }
        if (StringUtils.isNotBlank(server)) {
            return ServerListManagerFactory.getServerListManager("!Server", server, "pub", instanceMetaData);
        }
        return ServerListManagerFactory.getDefaultServerListManager("pub", instanceMetaData);
    }

    @Override
    synchronized boolean isSynchronized() {
        return this.isEnable() && this.isRegistered();
    }

    @Override
    public void addPackage(ProtocolPackage packagee) {
        if (this.cleanUpIfNecessary() || !this.isEnable()) {
            return;
        }
        InstanceMetaData instanceMetaData = this.registration.getInstanceMetaData();
        AttributeUtils.setInstanceMetaInPackage(packagee, instanceMetaData);
        packagee.addElement(this.regRequest);
        packagee.addElement(new AttributeElement("!Tenant", (Serializable)((Object)"true")));
        packagee.addElement(new AttributeElement("!ZIP", (Serializable)((Object)"true")));
        packagee.addElement(new AttributeElement("!Weight", (Serializable)((Object)"true")));
        packagee.addElement(new AttributeElement("!Lang", (Serializable)((Object)"java")));
        packagee.addElement(new AttributeElement("!Version", (Serializable)((Object)LocalConfigInfo.getVersion())));
        packagee.addElement(new AttributeElement("!SingleWeight", (Serializable)((Object)"true")));
        packagee.addElement(new AttributeElement("!MetaDataGroup", (Serializable)((Object)"true")));
        log.info("[Deliver] " + this.registration);
    }

    public void update(Revision revision, List<Object> datas, Map<String, List<ObserverData>> observerDatas) {
        if (this.isDisable()) {
            return;
        }
        if (datas == null && observerDatas != null) {
            this.data = new RevisedData(revision, observerDatas);
            int size = null == observerDatas ? 0 : observerDatas.size();
            log.info("########## [subscriber-update] " + this + ", dataWithMeta revision=" + this.data.getRevision() + ", observerDatas=" + this.getDataMsg(observerDatas));
        } else {
            this.data = new RevisedData(datas, revision);
            int size = null == datas ? 0 : datas.size();
            log.info("########## [subscriber-update] " + this + ", revision=" + this.data.getRevision() + ", count=" + size);
        }
        this.dataPushCount.incrementAndGet();
        this.notifyObServer();
    }

    public void notifyObServer() {
        if (this.isEnable()) {
            ConfigClientNotifier.notify(this);
        } else {
            log.error("s%", "[subscriber] disable subscriber received push data.");
        }
    }

    void signalObservers() {
        boolean isObserverDataNotNull;
        if (this.data.getData() == null && this.data.getObserverDataGroups() == null) {
            return;
        }
        List<Object> readOnlyDataView = null;
        boolean isDataNotNull = this.data.getData() != null;
        boolean bl = isObserverDataNotNull = this.data.getObserverDataGroups() != null;
        if (isDataNotNull) {
            readOnlyDataView = Collections.unmodifiableList(this.data.getData());
        }
        Map<String, Double> readOnlyWeightMapView = Collections.unmodifiableMap(this.weightValue);
        StringBuilder notifierLogSb = new StringBuilder();
        notifierLogSb.append("[Notifier] Notify " + this.toString());
        notifierLogSb.append(", rev=" + this.data.getRevision());
        notifierLogSb.append(", dataPushCount=" + this.dataPushCount);
        notifierLogSb.append(", weightPushCount=" + this.weightPushCount);
        notifierLogSb.append(", observers.size=" + this.observers.size());
        notifierLogSb.append(isDataNotNull ? "" : "data is null");
        notifierLogSb.append(isObserverDataNotNull ? "" : "ObserverData is null");
        boolean isDataPush = this.isNeedDataPushAndClear();
        boolean isWeightPush = this.isNeedWeightPushAndClear();
        notifierLogSb.append(", isDataPush=" + isDataPush);
        notifierLogSb.append(", isWeightPush=" + isWeightPush);
        log.info(notifierLogSb.toString());
        for (SubscriberDataObserver observer : this.observers) {
            try {
                if (observer instanceof WeightDataObserver && isDataNotNull) {
                    ((WeightDataObserver)observer).handleData(this.getDataId(), readOnlyDataView, readOnlyWeightMapView);
                }
                if (observer instanceof SubWeightDataObserver) {
                    if (isDataPush && isDataNotNull) {
                        log.info("[Notifier-data-detail] Notify " + this + ", rev=" + this.data.getRevision() + ",size=" + (this.data.getData() != null ? String.valueOf(this.data.getData().size()) : "null"));
                        observer.handleData(this.getDataId(), Collections.unmodifiableList(this.data.getData()));
                    }
                    if (isWeightPush) {
                        log.info("[Notifier-weight-detail] Notify " + this + ", rev=" + this.data.getRevision() + ",size=" + (this.weightValue != null ? String.valueOf(this.weightValue.size()) : "null"));
                        ((SubWeightDataObserver)observer).handleWeight(this.getDataId(), Collections.unmodifiableMap(this.weightValue));
                    }
                }
                if (observer instanceof SubMetaDataObserver && isObserverDataNotNull) {
                    if (!isDataPush) continue;
                    Map<String, List<ObserverData>> observerDataMap = Collections.unmodifiableMap(this.data.getObserverDataGroups());
                    String dataDetailMsg = this.getDataMsg(observerDataMap);
                    log.info("[Notifier-dataGroup-detail] Notify " + this + ", rev=" + this.data.getRevision() + ",dataDetailMsg=" + dataDetailMsg + ",subIpGroups=" + this.getRegistration().getSubIpGroups());
                    ((SubMetaDataObserver)observer).handleDataWithMeta(this.getDataId(), observerDataMap);
                    continue;
                }
                if (!isDataNotNull) continue;
                observer.handleData(this.getDataId(), readOnlyDataView);
            }
            catch (Throwable t) {
                log.warn("Exception in data observer of subscriber " + this.registration.getClientName() + " for data " + this.registration.getDataId() + ": ", t);
            }
        }
    }

    private String getDataMsg(Map<String, List<ObserverData>> observerDataMap) {
        StringBuilder dataDetailMsg = new StringBuilder("[");
        if (observerDataMap != null) {
            for (Map.Entry<String, List<ObserverData>> entry : observerDataMap.entrySet()) {
                String ipGroup = entry.getKey();
                List<ObserverData> observerDataList = entry.getValue();
                dataDetailMsg.append("(");
                dataDetailMsg.append(ipGroup);
                dataDetailMsg.append(",");
                dataDetailMsg.append(observerDataList != null ? Integer.valueOf(observerDataList.size()) : "null");
                dataDetailMsg.append(")");
            }
        } else {
            dataDetailMsg.append("null");
        }
        dataDetailMsg.append("]");
        return dataDetailMsg.toString();
    }

    private boolean isNeedDataPushAndClear() {
        boolean isDataPush = false;
        if (this.dataPushCount.get() > 0) {
            this.dataPushCount.getAndSet(0);
            isDataPush = true;
        }
        return isDataPush;
    }

    private boolean isNeedWeightPushAndClear() {
        boolean isWeightPush = false;
        if (this.weightPushCount.get() > 0) {
            this.weightPushCount.getAndSet(0);
            isWeightPush = true;
        }
        return isWeightPush;
    }

    public Revision revision() {
        return this.data.getRevision();
    }

    public int dataSize() {
        return this.data.getData() == null ? 0 : this.data.getData().size();
    }

    public String toString() {
        return "Subscriber (" + this.registration.getDataId() + ", " + this.registration.getGroup() + ", " + this.getClientId() + ", " + (this.getRegistration().getSubIpGroups() != null ? this.getRegistration().getSubIpGroups() : null) + ")";
    }

    public List<Object> getData() {
        return this.data.getData();
    }

    public Map<String, List<ObserverData>> getObserverDataGroups() {
        return this.data.getObserverDataGroups();
    }

    @Override
    public void addExcListener(ExcListener listener) {
        ExcEventDispatch.addListener(this.getRegistration().getDataId(), this.getRegistration().getGroup(), this.getRegistration().getTenant(), ExcRole.SUB, listener);
    }
}

