/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.ConfigClientPerfCtrl;
import com.taobao.config.client.DefaultDataClient;
import com.taobao.config.client.LocalConfigInfo;
import com.taobao.config.client.Publisher;
import com.taobao.config.client.PublisherRegistrar;
import com.taobao.config.client.PublisherRegistration;
import com.taobao.config.client.ServerListManager;
import com.taobao.config.client.ServerListManagerFactory;
import com.taobao.config.client.bean.InstanceMetaData;
import com.taobao.config.client.exception.ExcEvent;
import com.taobao.config.client.exception.ExcEventDispatch;
import com.taobao.config.client.exception.ExcListener;
import com.taobao.config.client.exception.ExcRole;
import com.taobao.config.client.exception.ExcType;
import com.taobao.config.client.utils.AttributeUtils;
import com.taobao.config.client.utils.StringUtils;
import com.taobao.config.common.ErrorType;
import com.taobao.config.common.Revision;
import com.taobao.config.common.protocol.AttributeElement;
import com.taobao.config.common.protocol.ProtocolPackage;
import com.taobao.config.common.protocol.PublisherDataElement;
import com.taobao.config.common.protocol.PublisherRegReqPacket;
import com.taobao.config.common.protocol.UserDataResultElement;
import com.taobao.middleware.logger.Logger;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;

public class DefaultPublisher<T extends Serializable>
extends DefaultDataClient
implements Publisher<T> {
    private final PublisherRegReqPacket regRequest;
    private volatile Object data = null;
    private volatile Revision revision = initialRevision;
    private Revision ackedRevision = initialRevision;
    private final String env;
    private static final Logger log = ConfigClientLogger.getLogger(DefaultPublisher.class);
    private static final Revision initialRevision = new Revision(1L);

    @Override
    public void publish(T datum) {
        String tmp;
        if (null == datum) {
            throw new IllegalArgumentException("cannot publish null");
        }
        if (this.isDisable()) {
            throw new IllegalStateException("Unregistered publisher cannot be reused.");
        }
        try {
            new ObjectOutputStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            }).writeObject(datum);
        }
        catch (IOException e) {
            throw new RuntimeException("Not serializable datum", e);
        }
        if (datum.getClass() == String.class && (tmp = (String)datum) != null && tmp.length() > ConfigClientPerfCtrl.dataContentLengthMax) {
            throw new IllegalArgumentException("publisher content length bigger than " + ConfigClientPerfCtrl.dataContentLengthMax + " :" + tmp);
        }
        this.doPublish(datum);
    }

    private synchronized void doPublish(Object datum) {
        this.data = datum;
        this.revision = this.revision.getUpdatedRevision();
        String dataId = this.getDataId();
        String publisherId = this.getClientId();
        if (datum == null) {
            log.info("[Publish] " + dataId + " (rev." + this.revision + ", by " + publisherId + "): (NULL)");
        } else {
            log.info("[Publish] dataId=" + dataId + ", clientId=" + publisherId + ", datumId=" + this.registration.getDatumId() + ", tenant=" + this.registration.getTenant() + ", rev=" + this.revision.getRevision() + ", env=" + this.env);
        }
        this.signalWorker();
    }

    @Override
    public PublisherRegistration<T> getRegistration() {
        return (PublisherRegistration)this.registration;
    }

    DefaultPublisher(PublisherRegistration<T> registration) {
        super(registration);
        Object center = registration.getLocalAttribute("!Center");
        Object server = registration.getLocalAttribute("!Server");
        this.env = center != null ? (String)center : (server != null ? (String)server : "default");
        String datumId = registration.getDatumId();
        this.regRequest = new PublisherRegReqPacket(registration.getDataId(), registration.getClientId(), datumId != null ? datumId : UUID.randomUUID().toString());
        for (Map.Entry attribute : registration.getAllAttributes()) {
            this.regRequest.setAttribute((String)attribute.getKey(), (Serializable)attribute.getValue());
        }
        this.serverMgr.incrementPubCount();
    }

    public synchronized void unregister() {
        if (super.setDisable()) {
            this.revision = this.revision.getUpdatedRevision();
            this.serverMgr.decrementPubCount();
            this.signalWorker();
        }
    }

    public synchronized Revision revision() {
        return this.revision;
    }

    public synchronized void setRevision(Revision revision) {
        this.revision = revision;
    }

    public synchronized boolean isDone() {
        return this.isRegistered() && this.ackedRevision.equals(this.revision);
    }

    @Override
    ServerListManager initServerManager() {
        String server = (String)this.registration.getLocalAttribute("!Server");
        String center = (String)this.registration.getLocalAttribute("!Center");
        InstanceMetaData instanceMetaData = this.registration.getInstanceMetaData();
        if (StringUtils.isNotBlank(center)) {
            return ServerListManagerFactory.getServerListManager("!Center", center, "pub", instanceMetaData);
        }
        if (StringUtils.isNotBlank(server)) {
            return ServerListManagerFactory.getServerListManager("!Server", server, "pub", instanceMetaData);
        }
        return ServerListManagerFactory.getDefaultServerListManager("pub", instanceMetaData);
    }

    @Override
    synchronized boolean isSynchronized() {
        return this.isEnable() && !this.isRegistered() && this.revision.equals(initialRevision) || this.isEnable() && this.isRegistered() && this.revision.equals(this.ackedRevision);
    }

    @Override
    public synchronized void addPackage(ProtocolPackage packagee) {
        if (this.cleanUpIfNecessary()) {
            return;
        }
        if (!this.isRegistered()) {
            packagee.addElement(this.regRequest);
            log.info("[Deliver] " + this.registration);
        }
        packagee.addElement(new AttributeElement("!Lang", (Serializable)((Object)"java")));
        packagee.addElement(new AttributeElement("!Version", (Serializable)((Object)LocalConfigInfo.getVersion())));
        InstanceMetaData instanceMetaData = this.registration.getInstanceMetaData();
        AttributeUtils.setInstanceMetaInPackage(packagee, instanceMetaData);
        String dataId = this.registration.getDataId();
        String publisherId = this.registration.getClientId();
        PublisherDataElement element = new PublisherDataElement(dataId, publisherId, this.revision);
        if (!this.isDisable()) {
            element.addData(Arrays.asList(this.data));
        }
        element.needAck = true;
        packagee.addElement(new AttributeElement("!Tenant", (Serializable)((Object)"true")));
        packagee.addElement(new AttributeElement("!MetaDataGroup", (Serializable)((Object)"true")));
        packagee.addElement(element);
        log.info("[Deliver] data. dataId=" + dataId + ", clientId=" + publisherId + ", datumId=" + this.registration.getDatumId() + ",tenant=" + ((PublisherRegistration)this.getRegistration()).getTenant() + ", rev=" + this.revision + ", env=" + this.env + (this.isDisable() ? ", unregister" : ""));
    }

    public synchronized void handleDataResult(UserDataResultElement element) {
        String message = null;
        if (this.isNotRegistered()) {
            message = "[Publish-error] Received result of data not yet registered!";
            log.error("%s", message);
            return;
        }
        String myDataId = this.getDataId();
        if (!element.dataId.equals(myDataId)) {
            message = "[Publish-error] Data ID of received user data result does not match with the publisher! (" + element.dataId + " != " + myDataId + ")";
            log.error("%s", message);
            return;
        }
        Revision receivedRevision = element.revision;
        if (null != element.error) {
            if (ErrorType.SPAS_VERIFY_FAILURE.getIdentifyCode().equals(element.error.getMessage())) {
                PublisherRegistrar.remove(this);
                String errorMessage = "[Publish or unregister error] spas-authentication-failed! dataId:" + myDataId + " group:" + ((PublisherRegistration)this.getRegistration()).getGroup() + " erorr:" + element.error + " receivedRevision:" + receivedRevision + " tenant:" + ((PublisherRegistration)this.getRegistration()).getTenant();
                log.error("%s", errorMessage);
                ExcEventDispatch.fireEvent(new ExcEvent(((PublisherRegistration)this.getRegistration()).getDataId(), ((PublisherRegistration)this.getRegistration()).getGroup(), ((PublisherRegistration)this.getRegistration()).getTenant(), ExcType.PUB_PERMISSION, errorMessage));
            } else {
                message = "[Publish-error] Data " + myDataId + "(" + receivedRevision + ") published by " + this.getClientId() + " is refused with error: " + element.error;
                log.error("%s", message);
                this.onServerDisconnected();
                ExcEventDispatch.fireEvent(new ExcEvent(((PublisherRegistration)this.getRegistration()).getDataId(), ((PublisherRegistration)this.getRegistration()).getGroup(), ((PublisherRegistration)this.getRegistration()).getTenant(), ExcType.UKNOWN, message));
            }
            return;
        }
        if (receivedRevision.isNewerThan(this.revision)) {
            log.warn("[Publish-error] " + myDataId + ", recvRev." + receivedRevision + " > rev." + this.revision);
            return;
        }
        if (receivedRevision.isOlderThan(this.ackedRevision)) {
            log.warn("[Publish-error] " + myDataId + ", recvRev." + receivedRevision + " < ackRev." + this.ackedRevision);
            return;
        }
        if (this.isDisable() && receivedRevision.equals(this.revision)) {
            PublisherRegistrar.remove(this);
            log.info("[unregister-ok] dataId=" + myDataId + ", clientId=" + this.getClientId() + ",tenant=" + ((PublisherRegistration)this.getRegistration()).getTenant() + ", env=" + this.env);
        } else {
            log.info("[Publish-ok] dataId=" + myDataId + ", clientId=" + this.getClientId() + ", datumId=" + this.registration.getDatumId() + ",tenant=" + ((PublisherRegistration)this.getRegistration()).getTenant() + ", rev=" + receivedRevision + ", env=" + this.env);
        }
        this.ackedRevision = receivedRevision;
    }

    public String getEnv() {
        return this.env;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Publisher (" + this.getClientId() + " for " + this.getDataId() + ")");
        sb.append("Tenant:" + this.registration.getTenant());
        String group = this.registration.getGroup();
        if (group != null) {
            sb.append(" in group " + group);
        }
        sb.append(" in env " + this.env);
        return sb.toString();
    }

    @Override
    public void addExcListener(ExcListener listener) {
        ExcEventDispatch.addListener(((PublisherRegistration)this.getRegistration()).getDataId(), ((PublisherRegistration)this.getRegistration()).getGroup(), ((PublisherRegistration)this.getRegistration()).getTenant(), ExcRole.PUB, listener);
    }
}

