/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.DataClient;
import com.taobao.config.client.DataClientRegistration;
import com.taobao.config.client.Publisher;
import com.taobao.config.client.PublisherRegistrar;
import com.taobao.config.client.ServerListManager;
import com.taobao.config.client.Subscriber;
import com.taobao.config.client.SubscriberRegistrar;
import com.taobao.config.common.protocol.ProtocolPackage;
import com.taobao.middleware.logger.Logger;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class DefaultDataClient
implements DataClient {
    static final Logger log = ConfigClientLogger.getLogger(DefaultDataClient.class);
    private final AtomicBoolean isEnable = new AtomicBoolean(true);
    private final AtomicBoolean isRegistered = new AtomicBoolean(false);
    protected volatile boolean registerResult = false;
    protected Error registerError = null;
    protected final DataClientRegistration registration;
    protected final ServerListManager serverMgr;

    DefaultDataClient(DataClientRegistration registration) {
        if (registration == null) {
            throw new NullPointerException("Registration is null.");
        }
        this.registration = registration;
        this.serverMgr = this.initServerManager();
    }

    void signalWorker() {
        this.serverMgr.getConfigClientWork().signal();
    }

    protected boolean isEnable() {
        return this.isEnable.get();
    }

    protected boolean isDisable() {
        return !this.isEnable.get();
    }

    protected boolean isRegistered() {
        return this.isRegistered.get();
    }

    protected boolean isNotRegistered() {
        return !this.isRegistered.get();
    }

    abstract ServerListManager initServerManager();

    abstract boolean isSynchronized();

    abstract void addPackage(ProtocolPackage var1);

    protected synchronized boolean setDisable() {
        return this.isEnable.getAndSet(false);
    }

    @Override
    public String getClientId() {
        return this.registration.getClientId();
    }

    @Override
    public String getDataId() {
        return this.registration.getDataId();
    }

    @Override
    public DataClientRegistration getRegistration() {
        return this.registration;
    }

    public synchronized void handleRegisterResult(boolean result, Error error) {
        this.isRegistered.set(true);
        this.registerResult = result;
        this.registerError = error;
        if (error == null) {
            log.info("[Register-ok] " + this);
        } else {
            log.warn("[Register-error] " + this + ", " + error);
        }
    }

    public synchronized void onServerDisconnected() {
        this.isRegistered.set(false);
        this.registerResult = false;
        this.registerError = null;
        this.signalWorker();
    }

    protected boolean cleanUpIfNecessary() {
        if (this.isDisable() && this.isNotRegistered()) {
            if (this instanceof Publisher) {
                PublisherRegistrar.remove((Publisher)((Object)this));
            } else if (this instanceof Subscriber) {
                SubscriberRegistrar.remove((Subscriber)((Object)this));
            }
            log.info("[direct-cleanup] " + this);
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.registration.getClientId().hashCode();
    }

    public ServerListManager getServerListManager() {
        return this.serverMgr;
    }
}

