/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.ServerListManager;
import com.taobao.config.client.remoting.ConnectionListener;
import com.taobao.config.client.remoting.ConnectionRequestProcessor;
import com.taobao.config.common.ConfigServerURL;
import com.taobao.config.common.protocol.ProtocolElement;
import com.taobao.config.common.protocol.ProtocolPackage;
import com.taobao.config.common.protocol.VersionElement;
import com.taobao.middleware.logger.Logger;
import com.taobao.remoting.Client;
import com.taobao.remoting.ClientManager;
import com.taobao.remoting.Connection;
import com.taobao.remoting.IOEventListener;
import com.taobao.remoting.Remoting;
import com.taobao.remoting.RemotingException;
import com.taobao.remoting.RequestProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConnectionProxy {
    private static final Logger log = ConfigClientLogger.getLogger(ConnectionProxy.class);
    private static int HEARTBEAT_PERIOD = 5;
    private static int CONNECTION_TIMEOUT = 3000;
    private static int COMMUNICATION_TIMEOUT = 3000;
    private static String port = null;
    private static final String APP_NAME;
    public static final ConcurrentMap<Connection, ServerListManager> allConnection;
    private List<IOEventListener> connectionListeners = new ArrayList<IOEventListener>(1);
    private Map<Class<?>, RequestProcessor<?>> requestProcessors = new HashMap();
    private final ServerListManager serverMgr;
    protected volatile Client client = null;
    protected int reConnected = 0;

    ConnectionProxy(ServerListManager serverMgr) {
        this.serverMgr = serverMgr;
        this.connectionListeners.add(new ConnectionListener(serverMgr.getConfigClientWork()));
        this.requestProcessors.put(ProtocolPackage.class, new ConnectionRequestProcessor(serverMgr.getConfigClientWork()));
    }

    boolean connect() throws InterruptedException {
        if (!this.isConnected()) {
            this.client = this.roll();
        }
        return this.isConnected();
    }

    protected Client roll() throws InterruptedException {
        Iterator<ConfigServerURL> iter = this.serverMgr.iterator();
        while (iter.hasNext()) {
            this.serverMgr.getConfigClientWork().waitUntilNormalMode();
            try {
                Client client = this.connectTo(iter.next(), this.connectionListeners, this.requestProcessors);
                if (null != client) {
                    return client;
                }
            }
            catch (Exception e) {
                log.error("%s", "[Global] Unexpected exception in server rolling: ", e);
            }
            Thread.sleep(5000L);
        }
        return null;
    }

    protected Client redirectServer(ConfigServerURL configServerURL) throws InterruptedException {
        this.serverMgr.getConfigClientWork().waitUntilNormalMode();
        try {
            Client client = this.connectTo(configServerURL, this.connectionListeners, this.requestProcessors);
            if (null != client) {
                return this.roll();
            }
        }
        catch (Exception e) {
            log.error("%s", "[Global] redirectServer Unexpected exception in server redirectServer: ", e);
        }
        return null;
    }

    public synchronized Client connectTo(ConfigServerURL address, List<IOEventListener> connListeners, Map<Class<?>, RequestProcessor<?>> requestProcessors) {
        log.info("[Global] Connecting to " + address + "...");
        String remotingUrl = this.makeRemotingUrl(address);
        ClientManager.ClientFuture cf = this.getClientManager().getAsync(APP_NAME, remotingUrl, this.connectionListeners, requestProcessors);
        try {
            Client client = cf.get(-1L);
            if (null != client && client.isConnected()) {
                log.info("[Global] Successfully connected to server: " + address);
                allConnection.put(client.getConnection(), this.serverMgr);
                ++this.reConnected;
                return client;
            }
        }
        catch (Exception e) {
            log.warn("Failed to connect to " + address + " due to " + e);
        }
        return null;
    }

    void close() {
        if (this.client == null) {
            return;
        }
        try {
            this.client.destroy();
        }
        catch (Throwable t) {
            log.error("%s", "[Network] Failed to close connection due to " + t);
        }
    }

    boolean isConnected() {
        return this.client != null && this.client.isConnected();
    }

    ProtocolPackage sendReceive(ProtocolPackage request) throws InterruptedException, RemotingException, RuntimeException {
        Object object;
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
        log.debug("[Message] Sending request: " + request.countElements() + " elements.");
        if (log.isDebugEnabled()) {
            this.dump(request);
        }
        if (!((object = this.client.invokeWithSync(request, null)) instanceof ProtocolPackage)) {
            log.debug("[Message] Invalid server response: " + (object == null ? "(NULL)" : object.getClass()));
            return null;
        }
        ProtocolPackage response = (ProtocolPackage)object;
        log.debug("[Message] Server response: " + response.countElements() + " elements");
        if (log.isDebugEnabled()) {
            this.dump(response);
        }
        return response;
    }

    void dump(ProtocolPackage message) {
        for (ProtocolElement element : message) {
            if (element.getClass() == VersionElement.class) continue;
            log.debug("[Message] >> " + element);
        }
    }

    private String makeRemotingUrl(ConfigServerURL address) {
        int idx = address.toString().indexOf(63);
        String query = idx > 0 ? address.toString().substring(idx) : "";
        StringBuilder addUrl = new StringBuilder();
        addUrl.append(address.getHost() + ":" + (port == null ? Integer.valueOf(address.getPort()) : port) + "?");
        addUrl.append("_SERIALIZETYPE=2");
        addUrl.append("&_AUTORECONNECT=false");
        addUrl.append("&_HEARBEAT=true");
        addUrl.append("&_IDLETIMEOUT=" + String.valueOf(HEARTBEAT_PERIOD));
        addUrl.append("&_CONNECTTIMEOUT=" + String.valueOf(CONNECTION_TIMEOUT));
        addUrl.append("&_TIMEOUT=" + String.valueOf(COMMUNICATION_TIMEOUT));
        addUrl.append("&_SERVERMGRCODE=" + String.valueOf(this.serverMgr.hashCode()));
        addUrl.append("&" + query);
        return addUrl.toString();
    }

    protected ClientManager getClientManager() {
        return Remoting.clientMgr();
    }

    public int getReConnected() {
        return this.reConnected;
    }

    static {
        String definPort = System.getProperty("configserver.client.port");
        if (null != definPort) {
            port = definPort;
        }
        APP_NAME = ConnectionProxy.class.getPackage().toString();
        allConnection = new ConcurrentHashMap<Connection, ServerListManager>();
    }
}

