/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.config.client;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class ConfigClientRegistration {
    volatile boolean used;
    private final String clientName;
    private final int instanceId;
    private final Map<String, Serializable> attributes = new HashMap<String, Serializable>();
    private final Map<String, Object> localAttributes = new HashMap<String, Object>();

    protected ConfigClientRegistration(String clientName, int instanceId) {
        if (clientName == null) {
            throw new IllegalArgumentException("clientName is null");
        }
        this.clientName = clientName;
        this.instanceId = instanceId;
    }

    public void setAttribute(String attribute, Serializable value) {
        if (value == null) {
            this.attributes.remove(attribute);
        } else {
            this.attributes.put(attribute, value);
        }
    }

    public <V extends Serializable> V getAttribute(String attribute) {
        return (V)this.attributes.get(attribute);
    }

    public String getStringAttribute(String id) {
        Object value = this.getAttribute(id);
        if (!(value instanceof String)) {
            return null;
        }
        return (String)value;
    }

    public Set<Map.Entry<String, Serializable>> getAllAttributes() {
        return this.attributes.entrySet();
    }

    public void setLocalAttribute(String attribute, Object value) {
        if (value == null) {
            this.localAttributes.remove(attribute);
        } else {
            this.localAttributes.put(attribute, value);
        }
    }

    public <V> V getLocalAttribute(String attribute) {
        return (V)this.localAttributes.get(attribute);
    }

    protected String getClientName() {
        return this.clientName;
    }

    protected String getClientId() {
        return this.clientName + "." + this.instanceId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.clientName.hashCode();
        result = 31 * result + this.attributes.hashCode();
        return 31 * result + this.localAttributes.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigClientRegistration)) {
            return false;
        }
        ConfigClientRegistration other = (ConfigClientRegistration)obj;
        if (!this.clientName.equals(other.clientName)) {
            return false;
        }
        if (!this.attributes.equals(other.attributes)) {
            return false;
        }
        return this.localAttributes.equals(other.localAttributes);
    }
}

