/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cs.shaded.com.alibaba.cs.shaded.com.taobao.middleware.logger.support;

import com.alibaba.cs.shaded.com.alibaba.cs.shaded.com.taobao.middleware.logger.support.AppenderInfo;
import com.alibaba.cs.shaded.com.alibaba.cs.shaded.com.taobao.middleware.logger.support.DepthThrowableRenderer;
import com.alibaba.cs.shaded.com.alibaba.cs.shaded.com.taobao.middleware.logger.support.LogLog;
import com.alibaba.cs.shaded.com.alibaba.cs.shaded.com.taobao.middleware.logger.support.LoggerInfo;
import com.alibaba.cs.shaded.com.alibaba.cs.shaded.org.apache.log4j.Appender;
import com.alibaba.cs.shaded.com.alibaba.cs.shaded.org.apache.log4j.AsyncAppender;
import com.alibaba.cs.shaded.com.alibaba.cs.shaded.org.apache.log4j.ConsoleAppender;
import com.alibaba.cs.shaded.com.alibaba.cs.shaded.org.apache.log4j.FileAppender;
import com.alibaba.cs.shaded.com.alibaba.cs.shaded.org.apache.log4j.Level;
import com.alibaba.cs.shaded.com.alibaba.cs.shaded.org.apache.log4j.LogManager;
import com.alibaba.cs.shaded.com.alibaba.cs.shaded.org.apache.log4j.Logger;
import com.alibaba.cs.shaded.com.alibaba.cs.shaded.org.apache.log4j.spi.LoggerRepository;
import com.alibaba.cs.shaded.com.alibaba.cs.shaded.org.apache.log4j.spi.ThrowableRenderer;
import com.alibaba.cs.shaded.com.alibaba.cs.shaded.org.apache.log4j.spi.ThrowableRendererSupport;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Log4jHelper {
    private static boolean Log4j;
    private static boolean Log4jGT1216;

    public static Boolean setDepth(int depth) {
        if (Log4jGT1216) {
            try {
                LoggerRepository repo = LogManager.getLoggerRepository();
                Log4jHelper.doSetDepth(repo, depth);
                return true;
            }
            catch (Throwable t) {
                LogLog.error("failed to set depth for log4j", t);
                return false;
            }
        }
        return null;
    }

    public static Boolean changeLevel(String name, String level) {
        if (Log4j) {
            Level l = Level.toLevel((String)level, (Level)Level.ERROR);
            Logger logger = LogManager.getLoggerRepository().exists(name);
            if (logger != null) {
                logger.setLevel(l);
                LogLog.info("set log4j log level success, " + name + ": " + l);
                return true;
            }
            LogLog.info("set log4j log level fail, no logger name exists: " + name);
            return false;
        }
        return null;
    }

    public static Map<String, LoggerInfo> getLoggers(String name) {
        HashMap<String, LoggerInfo> appenders = new HashMap<String, LoggerInfo>();
        if (!Log4j) {
            return appenders;
        }
        if (name != null && !"".equals(name.trim())) {
            Logger logger = LogManager.getLoggerRepository().exists(name);
            if (logger != null) {
                appenders.put(name, Log4jHelper.doGetLoggerInfo(logger));
            }
        } else {
            Logger root;
            LoggerInfo info;
            Enumeration loggers = LogManager.getLoggerRepository().getCurrentLoggers();
            if (loggers != null) {
                while (loggers.hasMoreElements()) {
                    Logger logger = (Logger)loggers.nextElement();
                    info = Log4jHelper.doGetLoggerInfo(logger);
                    if (info.getAppenders() != null && info.getAppenders().isEmpty()) continue;
                    appenders.put(logger.getName(), info);
                }
            }
            if (!((root = LogManager.getLoggerRepository().getRootLogger()) == null || (info = Log4jHelper.doGetLoggerInfo(root)).getAppenders() != null && info.getAppenders().isEmpty())) {
                appenders.put(root.getName(), info);
            }
        }
        return appenders;
    }

    private static LoggerInfo doGetLoggerInfo(Logger logger) {
        LoggerInfo info = new LoggerInfo(logger.getName(), logger.getAdditivity());
        Level level = logger.getLevel();
        Level effectiveLevel = logger.getEffectiveLevel();
        if (level != null) {
            info.setLevel(level.toString());
        }
        if (effectiveLevel != null) {
            info.setEffectiveLevel(effectiveLevel.toString());
        }
        List<AppenderInfo> result = Log4jHelper.doGetLoggerAppenders(logger.getAllAppenders());
        info.setAppenders(result);
        return info;
    }

    private static List<AppenderInfo> doGetLoggerAppenders(Enumeration<Appender> appenders) {
        ArrayList<AppenderInfo> result = new ArrayList<AppenderInfo>();
        while (appenders.hasMoreElements()) {
            AppenderInfo info = new AppenderInfo();
            Appender appender = appenders.nextElement();
            info.setName(appender.getName());
            info.setType(appender.getClass().getName());
            result.add(info);
            if (appender instanceof FileAppender) {
                info.setFile(((FileAppender)appender).getFile());
                continue;
            }
            if (appender instanceof ConsoleAppender) {
                info.withDetail("target", ((ConsoleAppender)appender).getTarget());
                continue;
            }
            if (!(appender instanceof AsyncAppender)) continue;
            List<AppenderInfo> asyncs = Log4jHelper.doGetLoggerAppenders(((AsyncAppender)appender).getAllAppenders());
            ArrayList<String> nestedNames = new ArrayList<String>();
            for (AppenderInfo a : asyncs) {
                nestedNames.add(a.getName());
                result.add(a);
            }
            info.withDetail("nestedNames", nestedNames);
        }
        return result;
    }

    private static void doSetDepth(LoggerRepository repo, int depth) {
        if (repo instanceof ThrowableRendererSupport) {
            ThrowableRenderer tr = ((ThrowableRendererSupport)repo).getThrowableRenderer();
            if (tr == null || !(tr instanceof DepthThrowableRenderer)) {
                DepthThrowableRenderer ctr = new DepthThrowableRenderer(depth);
                ((ThrowableRendererSupport)repo).setThrowableRenderer((ThrowableRenderer)ctr);
                LogLog.info("set log4j log depth success, depth: " + depth);
            } else {
                ((DepthThrowableRenderer)tr).setDepth(depth);
                LogLog.info("set log4j log depth success, depth: " + depth);
            }
        }
    }

    static {
        try {
            LogManager.getLoggerRepository();
            Log4j = true;
        }
        catch (Throwable t) {
            Log4j = false;
        }
        try {
            Class<?> throwableRendererClass = Class.forName("com.alibaba.cs.shaded.com.alibaba.cs.shaded.org.apache.log4j.spi.ThrowableRenderer");
            Class<?> loggerClass = Class.forName("com.alibaba.cs.shaded.com.alibaba.cs.shaded.org.apache.log4j.Logger");
            if (loggerClass.getClassLoader().equals(throwableRendererClass.getClassLoader()) && throwableRendererClass.getClassLoader().equals(Log4jHelper.class.getClassLoader())) {
                Log4jGT1216 = true;
            }
        }
        catch (Throwable t) {
            LogLog.warn("log4j must >= 1.2.16 for change throwable depth");
            Log4jGT1216 = false;
        }
    }
}

