/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cs.shaded.com.alibaba.cs.shaded.com.alibaba.configserver.com.caucho.services.server;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;

public abstract class AbstractSkeleton {
    private Class _apiClass;
    private Class _homeClass;
    private Class _objectClass;
    private HashMap _methodMap = new HashMap();

    protected AbstractSkeleton(Class apiClass) {
        this._apiClass = apiClass;
        Method[] methodList = apiClass.getMethods();
        for (int i = 0; i < methodList.length; ++i) {
            Method method = methodList[i];
            if (this._methodMap.get(method.getName()) == null) {
                this._methodMap.put(method.getName(), methodList[i]);
            }
            Class<?>[] param = method.getParameterTypes();
            String mangledName = method.getName() + "__" + param.length;
            this._methodMap.put(mangledName, methodList[i]);
            this._methodMap.put(this.mangleName(method, false), methodList[i]);
        }
    }

    public String getAPIClassName() {
        return this._apiClass.getName();
    }

    public String getHomeClassName() {
        if (this._homeClass != null) {
            return this._homeClass.getName();
        }
        return this.getAPIClassName();
    }

    public void setHomeClass(Class homeAPI) {
        this._homeClass = homeAPI;
    }

    public String getObjectClassName() {
        if (this._objectClass != null) {
            return this._objectClass.getName();
        }
        return this.getAPIClassName();
    }

    public void setObjectClass(Class objectAPI) {
        this._objectClass = objectAPI;
    }

    protected Method getMethod(String mangledName) {
        return (Method)this._methodMap.get(mangledName);
    }

    private String mangleName(Method method, boolean isFull) {
        StringBuffer sb = new StringBuffer();
        sb.append(method.getName());
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            sb.append('_');
            this.mangleClass(sb, params[i], isFull);
        }
        return sb.toString();
    }

    private void mangleClass(StringBuffer sb, Class cl, boolean isFull) {
        String name = cl.getName();
        if (name.equals("boolean") || name.equals("java.lang.Boolean")) {
            sb.append("boolean");
        } else if (name.equals("int") || name.equals("java.lang.Integer") || name.equals("short") || name.equals("java.lang.Short") || name.equals("byte") || name.equals("java.lang.Byte")) {
            sb.append("int");
        } else if (name.equals("long") || name.equals("java.lang.Long")) {
            sb.append("long");
        } else if (name.equals("float") || name.equals("java.lang.Float") || name.equals("double") || name.equals("java.lang.Double")) {
            sb.append("double");
        } else if (name.equals("java.lang.String") || name.equals("com.caucho.util.CharBuffer") || name.equals("char") || name.equals("java.lang.Character") || name.equals("java.io.Reader")) {
            sb.append("string");
        } else if (name.equals("java.util.Date") || name.equals("com.caucho.util.QDate")) {
            sb.append("date");
        } else if (InputStream.class.isAssignableFrom(cl) || name.equals("[B")) {
            sb.append("binary");
        } else if (cl.isArray()) {
            sb.append("[");
            this.mangleClass(sb, cl.getComponentType(), isFull);
        } else if (name.equals("org.w3c.dom.Node") || name.equals("org.w3c.dom.Element") || name.equals("org.w3c.dom.Document")) {
            sb.append("xml");
        } else if (isFull) {
            sb.append(name);
        } else {
            int p = name.lastIndexOf(46);
            if (p > 0) {
                sb.append(name.substring(p + 1));
            } else {
                sb.append(name);
            }
        }
    }
}

