/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.handler;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.ByteBuffer;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IdleStatus;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoHandlerAdapter;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoSession;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.handler.support.IoSessionInputStream;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.handler.support.IoSessionOutputStream;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.util.SessionLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;

public abstract class StreamIoHandler
extends IoHandlerAdapter {
    private static final String KEY_IN = StreamIoHandler.class.getName() + ".in";
    private static final String KEY_OUT = StreamIoHandler.class.getName() + ".out";
    private int readTimeout;
    private int writeTimeout;

    protected StreamIoHandler() {
    }

    protected abstract void processStreamIo(IoSession var1, InputStream var2, OutputStream var3);

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void sessionOpened(IoSession session) {
        session.setWriteTimeout(this.writeTimeout);
        session.setIdleTime(IdleStatus.READER_IDLE, this.readTimeout);
        IoSessionInputStream in = new IoSessionInputStream();
        IoSessionOutputStream out = new IoSessionOutputStream(session);
        session.setAttribute(KEY_IN, in);
        session.setAttribute(KEY_OUT, out);
        this.processStreamIo(session, in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(IoSession session) throws Exception {
        InputStream in = (InputStream)session.getAttribute(KEY_IN);
        OutputStream out = (OutputStream)session.getAttribute(KEY_OUT);
        try {
            in.close();
        }
        finally {
            out.close();
        }
    }

    public void messageReceived(IoSession session, Object buf) {
        IoSessionInputStream in = (IoSessionInputStream)session.getAttribute(KEY_IN);
        in.write((ByteBuffer)buf);
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        IoSessionInputStream in = (IoSessionInputStream)session.getAttribute(KEY_IN);
        IOException e = null;
        if (cause instanceof StreamIoException) {
            e = (IOException)cause.getCause();
        } else if (cause instanceof IOException) {
            e = (IOException)cause;
        }
        if (e != null && in != null) {
            in.throwException(e);
        } else {
            SessionLog.warn(session, "Unexpected exception.", cause);
            session.close();
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        if (status == IdleStatus.READER_IDLE) {
            throw new StreamIoException(new SocketTimeoutException("Read timeout"));
        }
    }

    private static class StreamIoException
    extends RuntimeException {
        private static final long serialVersionUID = 3976736960742503222L;

        public StreamIoException(IOException cause) {
            super(cause);
        }
    }
}

