/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.filter.codec.serialization;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.ByteBuffer;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoSession;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.filter.codec.ProtocolEncoderOutput;
import java.io.NotSerializableException;
import java.io.Serializable;

public class ObjectSerializationEncoder
extends ProtocolEncoderAdapter {
    private int maxObjectSize = Integer.MAX_VALUE;

    public int getMaxObjectSize() {
        return this.maxObjectSize;
    }

    public void setMaxObjectSize(int maxObjectSize) {
        if (maxObjectSize <= 0) {
            throw new IllegalArgumentException("maxObjectSize: " + maxObjectSize);
        }
        this.maxObjectSize = maxObjectSize;
    }

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        if (!(message instanceof Serializable)) {
            throw new NotSerializableException();
        }
        ByteBuffer buf = ByteBuffer.allocate(64);
        buf.setAutoExpand(true);
        buf.putObject(message);
        int objectSize = buf.position() - 4;
        if (objectSize > this.maxObjectSize) {
            buf.release();
            throw new IllegalArgumentException("The encoded object is too big: " + objectSize + " (> " + this.maxObjectSize + ')');
        }
        buf.flip();
        out.write(buf);
    }
}

